## CVE-2025-47917 Exploit (Use-After-Free in mbedTLS)
# Author       : Byte Reaper
# Telegram     : [@ByteReaper0](https://t.me/ByteReaper0)
# CVE          : CVE-2025-47917
# Vulnerability :  Use-After-Free (UAF) in mbedTLS 3.6.4 name parsing

---

## Description

This repository contains an exploit targeting a Use-After-Free vulnerability in the mbedtls_x509_string_to_names() name parsing function of the mbedTLS library. A successful exploit grants arbitrary code execution with root privileges by hijacking freed heap metadata and redirecting control flow to injected shellcode.

---

## Prerequisites

1. **Operating System**: Linux (tested on Kali Linux)
2. **Root privileges**: Required for disabling ASLR and executing injected shellcode
3. **mbedTLS development libraries (mbedTLS < 3.6.4)**:

   ```
   sudo apt update
   sudo apt install -y libmbedtls-dev
   ```
4. **Build tools**: `gcc`, `make` (optional)

---

## Compilation

Adjust include/library paths according to your installation:

```
gcc /path/to/exploit.c \
    -I/usr/local/include \
    -L/usr/local/lib \
    -lmbedtls -lmbedx509 -lmbedcrypto \
    -Wl,-rpath,/usr/local/lib \
    -o exploit_UAF
```

---

## Usage

1. **Disable ASLR** (Address Space Layout Randomization):

   ```
   echo 0 | sudo tee /proc/sys/kernel/randomize_va_space
   ```
2. **Prepare a listener** for the reverse shell on attacker machine (port 4454):

   ```
   nc -lvnp 4454
   ```
3. **Run the exploit** with root privileges:

   ```
   sudo ./exploit_UAF
   ```

---

## Exploitation Workflow

1. **ASLR Check**: `checkAslr()` reads `/proc/sys/kernel/randomize_va_space` to ensure ASLR is disabled. Exits if enabled.
2. **First `mbedtls_x509_string_to_names()` call**: Initializes an empty named-data list.
3. **Heap Spray**: `paddingChunk()` allocates many fake named-data structs to fill free list entries with controlled content pointing to shellcode.
4. **Second `mbedtls_x509_string_to_names()` call**: Triggers the Use-After-Free condition, reuses freed chunk containing fake metadata.
5. **Shellcode Injection**: Shellcode is mapped RWX via `mmap()`, copied, and executed through corrupted `named_data->val.p` pointer.

---

## Reverse Shell Shellcode

* **Target IP**: `192.168.92.187`
* **Target Port**: `4454`

The shellcode performs a `socket` + `connect` + `dup2` sequence, then `execve("/bin/sh")`.

---

## Ethical and Legal Disclaimer

* This code is provided **for authorized security research and educational purposes only**.
* Unauthorized use against systems for which you do not have explicit permission is illegal and unethical.
* Always obtain written permission before testing on any network or host.

---

## License

MIT
