
# CVE-2025-47577 - WordPress TI WooCommerce Wishlist <= 2.9.2 - Arbitrary File Upload

## 🔥 Vulnerability Summary
The WordPress plugin **TI WooCommerce Wishlist** version **<= 2.9.2** is vulnerable to an **unauthenticated arbitrary file upload** vulnerability. This allows attackers to upload any file type, including executable PHP files, potentially leading to **Remote Code Execution (RCE)**.

This vulnerability arises due to the lack of proper MIME-type and content validation on the upload endpoint `/`, allowing attackers to upload a file through a specially crafted `multipart/form-data` POST request.

## 🔍 Affected Plugin
- **Plugin Name:** TI WooCommerce Wishlist
- **Affected Version:** <= 2.9.2
- **Vulnerability Type:** Unauthenticated Arbitrary File Upload
- **CVE ID:** CVE-2025-47577
- **CVSS Score:** 9.8 (Critical)
- **Impact:** Remote Code Execution (RCE)

## 🧪 Exploit Features
- 🔎 Automatically grabs `product_id` from homepage (`data-tinv-wl-product`)
- 🖼 Uploads arbitrary file (e.g., image or PHP) using the wishlist endpoint
- 🔗 Extracts wishlist share key from JSON response
- 📁 Checks `/wishlist/<key>` for uploaded image path
- 💾 Saves valid uploaded image URLs to `result.txt`
- 💾 Saves valid wishlist URLs to `result_wishlist.txt`

## 🧠 Researcher
Credit: [Patchstack Database](https://patchstack.com/database/wordpress/plugin/ti-woocommerce-wishlist/vulnerability/wordpress-ti-woocommerce-wishlist-2-9-2-arbitrary-file-upload-vulnerability)

## 🚀 Usage

1. Prepare your `list.txt` file with a list of target domains (one per line, without `http`).
2. Place the file you want to upload (e.g. `hinata.jpg`) in the same folder.
3. Run the script:

```bash
python3 CVE-2025-47577.py
```

### Example `list.txt`:
```
example.com
targetshop.org
store123.net
```

## 📁 Output
- `result.txt`: List of successful uploaded image URLs
- `result_wishlist.txt`: List of valid wishlist pages

---

🔒 **Disclaimer**: This script is for educational and authorized testing purposes only.
