
# 🚨 CVE-2025-47539 – WordPress Eventin Plugin Critical Exploit

## 🔥 Vulnerability Summary
The **Event Manager, Events Calendar, Tickets, Registrations – Eventin** plugin for WordPress is vulnerable to **unauthenticated privilege escalation** due to a missing authorization check in the `import_items()` function.

- 🔓 Affected Versions: `<= 4.0.26`
- 🆔 CVE: `CVE-2025-47539`
- 🚨 CVSS Score: `9.8 (Critical)`
- 📅 Public Disclosure: `May 7, 2025`
- 🔄 Last Updated: `May 15, 2025`

Unauthenticated attackers can craft a malicious request to the REST API and create a new user with `administrator` privileges without any user interaction.

---

## 💻 About the Script

This Python script is a standalone exploitation tool for CVE-2025-47539.

It will:
- Auto-generate a valid CSV payload file.
- Upload the file to the vulnerable endpoint.
- Automatically trigger the import process.
- Provide immediate feedback including full credentials of the created admin account.

> ⚠️ This script is intended for educational use and professional security assessments only.

---

## ⚙️ Usage

```bash
usage: a.py [-h] -u URL

Exploit for CVE-2025-47539 # By Nxploited (Khaled Alenazi)

options:
  -h, --help     show this help message and exit
  -u, --url URL  Target base URL (e.g. http://target.com)
```

---

## ✅ Expected Output

```bash
By:Nxploited (Khaled_alenazi) |    NxploitBot@gmail.com
[+] Exploitation succeeded
[+] Response:
{"message":"Successfully imported speaker"}

[+] Exploited Account Details
    Name     : Nxploited (Khaled_alenazi)
    Email    : Nxploit@admin.sa
    Username : NxPloted
    Password : nxploit123
    Role     : administrator

Exploit: By: Nxploited (Khaled_alenazi)
Use this script for educational purposes only. I am not responsible for your actions.
```

---

## 📊 Impact

More than **10,000+** WordPress sites are confirmed to be vulnerable to this exploit.  
All site administrators using Eventin **≤ 4.0.26** should **immediately update** to version `4.0.28` or later.

---

## ⚠️ Disclaimer

This tool is provided **for educational and authorized penetration testing** purposes only.  
The creator is **not responsible for any misuse or damage** caused by this script.

---

## 👤 

**By:** Nxploited ( Khaled_Alenazi )  
📧 **Contact:** NxploitBot@gmail.com
