# CVE-2025-47256
Stack overflow in LibXMP

# Description
A stack-based buffer overflow vulnerability exists in the depack_pha() function of libxmp, a library for module music playback. The vulnerability is triggered when parsing malformed Pha Packer (PHA) module files.

Improper bounds checking on a local stack buffer allows an attacker to write data outside the bounds of the array, potentially leading to denial-of-service (DoS), and in certain conditions, remote code execution (RCE).

Build:
`gcc -g -O0 -I./libxmp/include poc.c poc_data.h ./libxmp/lib/libxmp.a -lm -lz -o poc_crasher`

# Vulnerability Type
Stack Buffer Overflow

# Vendor
libxmp project
GitHub: https://github.com/libxmp/libxmp
Issue: https://github.com/libxmp/libxmp/issues/847

# Affected Component
src/loaders/prowizard/pha.c
Function: depack_pha()

# Impacts
Denial of Service (DoS)
Potential Remote Code Execution (RCE) under specific build or runtime conditions

# Attack Vectors
An attacker can craft a malicious .mod or .pha file in Pha Packer format and feed it to any application linked with libxmp. The malformed file causes a stack buffer overflow during pattern parsing in depack_pha().

# Vendor Acknowledgment
This issue is in the process of being reported to the libxmp maintainers via GitHub Issues.

# Discoverer
Gareth C - https://www.anchorsec.co.uk
