# CVE-2025-47226 - IDOR Vulnerability in Snipe-IT <= v8.0.4

🚨 Insecure Direct Object Reference (IDOR) vulnerability in Snipe-IT allows authenticated users to view asset information from other departments by tampering with `location_id`.

## ✍️ Discovered By

**Siripong Jintung**  

GitHub: [Sn1p3r-H4ck3r](https://github.com/koyomihack00)
Linkedin: www.linkedin.com/in/siripong-j-885b652b6)
, Offensive Security Specialist | Movaci Co., Ltd.

---

## 📋 PoC Summary

| Field | Details |
|-------|---------|
| **CVE ID** | CVE-2025-47226 |
| **Product** | Snipe-IT (by Grokability) |
| **Affected Version** | <= v8.0.4 |
| **Patched Version** | v8.1.0 |
| **Type** | Insecure Direct Object Reference (IDOR) |
| **Endpoint** | `/locations/{id}/printassigned` |

## 🧪 Proof of Concept

See [PoC/idor-exploit.md](./PoC/idor-exploit.md) for detailed steps to reproduce.

## 🔐 Impact

- Unauthorized disclosure of asset inventory and assignments between departments.
- Breakdown of internal data boundaries in multi-departmental deployments.

## 🩹 Patch

- Patch PR: https://github.com/grokability/snipe-it/pull/16672
- Release: https://github.com/grokability/snipe-it/releases/tag/v8.1.0

## 📚 References

- [CVE Record](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-47226)
- https://www.cve.org/CVERecord?id=CVE-2025-47226
- https://nvd.nist.gov/vuln/detail/CVE-2025-47226
