# CVE-2025-46822
 Unauthenticated Arbitrary File Read via Absolute Path 

 ## Description:
While Path.resolve() method is being used to protect against path traversal I have found that the usage of absolute path successfully read internal files , the endpoint is also not authenticated this means anyone can read the entire organization's files, file system from wherever the store root in: files.store.root = /file-store/ as configured in application-dev.properties, this allows unauthorized access to sensitive internal files.

## Details:
the storageService.loadAsResource() method uses Path.resolve() without first ensuring that the input name is a relative path and that the resolved path stays within the intended file storage root, then providing an absolute path as the fileName will directly lead to accessing that arbitrary file.

also, the /api/v1/files/{fileName} endpoint is exposed without any authentication or authorization checks, allowing any unauthenticated user to access files.

usage:

```
python3 CVE-2025-46822.py http://victim.com /etc/passwd
```

Links:
- https://nvd.nist.gov/vuln/detail/CVE-2025-46822
- https://d3sca.medium.com/cve-2025-46822-the-story-of-an-unauthenticated-arbitrary-file-read-via-absolute-path-1745ba39460e
- https://github.com/OsamaTaher/Java-springboot-codebase/security/advisories/GHSA-q6mm-cm37-w637
