# CVE-2025-46157
# CVE-2025-46157 – Timetrax V1 (2025) Remote Code Execution and Privilege Escalation

## Summary

A critical vulnerability was discovered in **Timetrax V1 (2025)** that allows authenticated users to bypass file upload restrictions and achieve **remote code execution (RCE)**. The issue exists in the **Leave Request form of the Attendance module**, where weak server-side validation permits the upload of malicious `.asp` web shells via modified requests.

Further exploitation allows **privilege escalation to SYSTEM** using the **EfsPotato** technique by abusing the `SeImpersonatePrivilege`.

---

## Vulnerability Details

### ✅ Remote Code Execution (RCE)
- **Component:** Leave Request form in Attendance module
- **Cause:** Insecure server-side file validation
- **Attack Vector:** Modify upload request to change `.txt` to `.asp`
- **Impact:** Full command execution on the server

### ✅ Privilege Escalation
- **Technique:** EfsPotato
- **Privilege Misuse:** `SeImpersonatePrivilege`
- **Result:** SYSTEM-level access
- **AV Evasion:** Achieved using obfuscated payloads

---

## CVSS v3.1 Score

**Base Score:** 9.9 (Critical)  
**Vector String:** `CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H`

---

## Proof of Concept (PoC)

### 1. Remote Code Execution

1. Login to Timetrax with valid user credentials.
2. Go to the **Leave Request form** under the Attendance module.
3. Upload a `.txt` file, intercept the HTTP request using Burp Suite.
4. Modify the file extension in the request from `.txt` to `.asp`.
5. Forward the request. The server will return a URL to the uploaded file.
6. Visit the URL to trigger the malicious web shell.

### 2. Privilege Escalation

- Use the [EfsPotato](https://github.com/zcgonvh/EfsPotato) exploit to abuse `SeImpersonatePrivilege`.
- Obfuscate the binary or payload to bypass AV detection.
- Gain SYSTEM-level shell and create a new Administrator account as proof.

---

## Affected Version

- **Timetrax V1 (2025)**

---

## Mitigation

- Enforce strong password policies and enable MFA
- Properly validate and sanitize uploaded files on the server
- Restrict `SeImpersonatePrivilege` to required accounts only
- Apply OS patches to mitigate EfsPotato
- Disable EFS if not required

---

## Disclosure

- **Discovered by:** Noman Azam  
- **Email:** noman@technobiz.com.pk  
- **CVE ID:** CVE-2025-46157

---

## References

- [EfsPotato Exploit](https://github.com/zcgonvh/EfsPotato)

---

> This repository is part of responsible disclosure and educational purposes only. Always follow ethical guidelines and coordinated disclosure policies.
