# Obfuscated by YetaHub V1.2 Beta
import base64,zlib,hashlib,sys
from getpass import getpass

CRYPTO_AVAILABLE = False
try:
    from Crypto.Cipher import AES
    CRYPTO_AVAILABLE = True
except Exception:
    CRYPTO_AVAILABLE = False

enc_data = "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"
checksum_expected = "16278e3da278c197b274a645bd28ea0d2f2cd6645aac7c51b7da8949716143e9"
mode = "NO-PASS"
fixed_key = "OhangXWebVandID_v1.2Beta"
salt_hex = ""
iters = 0

def sha256_hex(b): return hashlib.sha256(b).hexdigest()

def derive_key(password, salt, iters=200000, dklen=32):
    return hashlib.pbkdf2_hmac("sha256", password.encode(), salt, iters, dklen)

def xor_bytes(data, key):
    k = key.encode()
    return bytes(b ^ k[i % len(k)] for i, b in enumerate(data))

def abort(msg):
    print("❌", msg); sys.exit(1)

try:
    if mode == "AES-GCM":
        if not CRYPTO_AVAILABLE:
            abort("Crypto lib tidak tersedia.")
        blob = base64.b64decode(enc_data)
        nonce = blob[:12]
        tag = blob[12:28]
        ciphertext = blob[28:]

        passwd = getpass("🔐 Masukkan password dekripsi: ")
        if not passwd:
            abort("Password kosong.")

        salt = bytes.fromhex(salt_hex)
        key = derive_key(passwd, salt, iters, 32)

        cipher = AES.new(key, AES.MODE_GCM, nonce=nonce)
        step = cipher.decrypt_and_verify(ciphertext, tag)

    elif mode == "NO-PASS":
        step = base64.b64decode(enc_data)

    else:
        abort("Mode tidak dikenal.")

except Exception as e:
    abort("Decode error: " + str(e))

try:
    step = xor_bytes(step, fixed_key)[::-1]
    hexstr = step.decode()
    step = bytes.fromhex(hexstr)
    step = base64.b64decode(step)
    original = zlib.decompress(step).decode()
except Exception:
    abort("Gagal proses dekripsi.")

if sha256_hex(original.encode()) != checksum_expected:
    abort("Integrity check gagal!")

exec(original)
