# CVE-2025-4606

**CVE-2025-4606** is a security assessment tool for **educational and research purposes**.  
It is designed to help identify vulnerabilities in WordPress themes, specifically the **Sala – Startup & SaaS WordPress Theme**.

---
## Description

The **Sala WordPress Theme** (all versions ≤ 1.1.4) is vulnerable to **privilege escalation via account takeover**.  
The theme does not properly validate a user's identity before updating sensitive details such as passwords.  
This allows **unauthenticated attackers** to change arbitrary user passwords, including administrators, potentially gaining full access.

---

## CVSS 3.x Severity and Vector

- **CNA:** Wordfence  
- **Base Score:** 9.8 (CRITICAL)  
- **Vector:** `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H`  
- **Note:** NIST CVSS score may not match CNA score  

---

## Usage

Use this tool only for **educational, research, and defensive purposes**.  
Do **not** use it on live websites without proper authorization.

---

# Screenshot
![Screenshot](https://files.catbox.moe/tznxs6.jpg)

---

# Requirements
- Termux (Android)
- Pydroid 3 (Android)

---

# If the script shows
- Scan completed
- Results saved to adminsucces.txt

---

# But the file does not appear when running
- ls
- cat adminsucces.txt

---

# Bulk Site Scan (From Files)
- cd CVE-2025-4606
- ~/CVE-2025-4606 $ ls ( View files)
- ~/CVE-2025-4606 $ nano target.txt ( save files )
- example files: https://example.com
- CTRL + S to save | CTRL + X to exit
- ~/CVE-2025-4606 $ python scanner.py


---

# Disclaimer

This tool is intended for **ethical use only**.  
The author is not responsible for any misuse or damage caused.

---

# Installation
```bash
git clone https://github.com/Yetazyyy/CVE-2025-4606.git
cd CVE-2025-4606
python scanner.py
