# Anchor CMS v0.12.7 - Stored XSS (CVE-2025-46041)

Anchor CMS v0.12.7 is vulnerable to a **Stored Cross-Site Scripting (XSS)** vulnerability in the `description` field of the `/admin/pages/add` interface.

## CVE ID

[CVE-2025-46041](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-46041)

## Summary

* **Type:** Stored XSS
* **Location:** Page creation interface (`/admin/pages/add`)
* **Impact:** Arbitrary JavaScript execution
* **Authentication Required:** Yes (admin or editor user)
* **Affected Version:** Anchor CMS v0.12.7 (latest stable at time of discovery)

## Proof of Concept

1. Login to `/admin`
2. Go to `Pages > Add Page`
3. In the `Description` field, insert:

   ```html
   <script>alert(document.domain)</script>
   ```
4. Save the page.
5. Revisit the page view — the payload executes.

## Affected Component

* File: `anchor/routes/pages.php`
* Field: `description`

## Tested On

* Ubuntu 22.04
* Apache2 + PHP 8.1
* Anchor CMS v0.12.7 (fresh install)

## Discoverer

[@binneko](https://github.com/binneko)

## References

* [Anchor CMS GitHub](https://github.com/anchorcms/anchor-cms)
* [CVE Record - CVE-2025-46041](https://cve.mitre.org)

## Disclaimer

For educational and defensive purposes only.

