# CVE-2025-45960 - tawk.to Live chat - 1.6.1 - Cross-Site Scripting (XSS) Vulnerability

## Confirmed on 1.6.1 (older versions likely affected)

## Description:
Found that the web application stores and displays user-supplied input without proper input validation or encoding. This leading to a malicious code stored on the server and later rendered to the user's web browser without appropriate sanitization. For example, the tester could stored malicious JavaScript on live chat and it can be executed on the website.

## Impact:
Allows an attackers to inject malicious code into the parameter on the system and potentially harm the users of the web application if user access the webpage that's malicious code stored. For example steal sensitive information, phishing attacks, damage to brand reputation.

## Proof of Concept (PoC):

Our testing revealed that the chat input field lacks sufficient input validation, allowing testers to inject HTML tags containing JavaScript code. When such a tag is clicked by a user, the embedded JavaScript executes within the user’s browser context. This behavior confirms the presence of a Stored Cross-Site Scripting vulnerability.

```
Payload: <img src='x' onclick='alert(document.domain)'>
```
![image](https://github.com/user-attachments/assets/49ce44a2-35e1-4101-9305-b434cacd98c4)


![image](https://github.com/user-attachments/assets/1661a1b6-0039-4391-a2df-f55226815e14)
