# U-Boot 1.1.3 Exploit PoC Usage Guide

## Introduction

This Proof of Concept (PoC) was created to verify vulnerabilities in the U-Boot bootloader version 1.1.3 compiled on August 27, 2019. The code implements five different vulnerabilities relevant to the OWASP IoT Security Testing Guide (ISTG) categories.

**WARNING:** Use this PoC only on devices that you have permission to test. Usage on systems without permission may violate applicable laws.

## Requirements

1. Python 3.6+
2. Physical access to the target device via serial interface (UART)
3. The following Python packages:
   - pyserial
   - cryptography

## Installation

```bash
# Install required libraries
pip install pyserial cryptography
```

## Hardware Connection

To use this PoC, you need to connect to the serial interface of the target device:

1. Identify the UART pins on the target device (typically TX, RX, and GND)
2. Connect using a USB-to-UART adapter or other serial device
3. Note the serial port name (e.g., `/dev/ttyUSB0` on Linux, `COM3` on Windows)

## Usage

This script offers several operation modes to test each vulnerability separately or all at once.

### Running All Exploits

```bash
python3 uboot_exploit_poc.py --port /dev/ttyUSB0
```

### Running Specific Exploits

You can run a specific exploit with the `--exploit` parameter:

```bash
# Test the "Insecure Update Mechanism" vulnerability
python3 uboot_exploit_poc.py --port /dev/ttyUSB0 --exploit 1

# Test the "Hardcoded Sensitive Values" vulnerability
python3 uboot_exploit_poc.py --port /dev/ttyUSB0 --exploit 2

# Test the "Debugging Interface Access" vulnerability
python3 uboot_exploit_poc.py --port /dev/ttyUSB0 --exploit 3

# Test the "No Protection Against Firmware Downgrade" vulnerability
python3 uboot_exploit_poc.py --port /dev/ttyUSB0 --exploit 4

# Test the "Missing Secure Channel for Updates" vulnerability
python3 uboot_exploit_poc.py --port /dev/ttyUSB0 --exploit 5
```

### Additional Parameters

```bash
# Change the baudrate (default: 115200)
python3 uboot_exploit_poc.py --port /dev/ttyUSB0 --baudrate 57600

# Change the serial timeout (default: 1 second)
python3 uboot_exploit_poc.py --port /dev/ttyUSB0 --timeout 2
```

## Output

The script will create a directory called `uboot_extracted` containing:

1. Exploitation logs for each vulnerability
2. Extracted sensitive values
3. Evidence of debugging access
4. Anti-rollback testing results
5. Evidence of insecure communication channels

The file `full_exploitation_summary.txt` provides a complete summary of all vulnerability tests.

## Vulnerability Descriptions

### 1. Insecure Update Mechanism (IOT-FW-02)
The bootloader lacks proper signature verification for firmware updates, allowing the installation of unauthorized firmware.

### 2. Hardcoded Sensitive Values (IOT-DES-05)
Sensitive values such as credentials and keys are hardcoded in the bootloader binary, allowing extraction of sensitive information.

### 3. Debugging Interface Access (IOT-PHY-03)
The debugging interface is insufficiently protected, allowing access to low-level system controls without authentication.

### 4. No Protection Against Firmware Downgrade (IOT-FW-07)
The bootloader lacks anti-rollback mechanisms, allowing downgrades to versions with known vulnerabilities.

### 5. Missing Secure Channel for Updates (IOT-INT-02)
Firmware updates are transmitted over insecure channels without encryption or authentication, allowing interception and modification.

## Contributing to CVE Submission

The evidence collected by this PoC can be used to support a CVE submission. For CVE submission:

1. Collect all logs and evidence from the `uboot_extracted` directory
2. Document exact versions and configurations tested
3. Provide remediation suggestions based on test results
4. Follow responsible disclosure practices by notifying the vendor first

## Legal Disclaimer

This tool is provided for educational and professional security testing purposes only. The authors are not responsible for any misuse or damage caused by this tool. Always obtain proper authorization before testing any system or device.
