# CVE-2025-45466
It is the details of CVE-2025-45466

# CVE Disclosure: CVE-2025-45466  

## Summary

A vulnerability has been discovered in **Unitree Go1** robotic dog (all versions <= `Go1_2022_05_11`) involving **hardcoded plaintext authentication credentials**, which leads to **Incorrect Access Control**. This issue allows remote or local attackers to gain unauthorized access to the system via SSH or SCP, potentially resulting in **remote code execution**, **privilege escalation**, and **information disclosure**.

---

## Vulnerability Details

- **Vulnerability Type:** Incorrect Access Control  
- **Impact:**  
  - Remote Code Execution ✅  
  - Privilege Escalation ✅  
  - Information Disclosure ✅  
- **Attack Vector:**  
  An attacker can extract the firmware, inspect a specific script (`/run.sh`), and find hardcoded plaintext credentials used for SSH/SCP authentication. With these credentials, the attacker can access the robot remotely via:
    - **Wi-Fi client mode**  
    - **Wi-Fi AP mode**  
    - **Physical access via Ethernet interface**

---

## Affected Products

- **Vendor:** [Unitree Robotics](https://www.unitree.com/cn/go1)  
- **Product:** Unitree Go1  
- **Affected Versions:** All firmware versions ≤ `Go1_2022_05_11`  
- **Affected Component:** `/run.sh` in the firmware  
- **Firmware Package URL (Archived):**  
  [Go1_2022_05_11_e0d0e617.zip](https://unitreeapp.oss-cn-beijing.aliyuncs.com/Go1_2022_05_11_e0d0e617.zip)

---

## Proof of Concept (PoC)

1. **Download the affected firmware**  
2. grep -i "password" run.sh
3. ssh root@<robot_ip> # using the hardcoded password
4. Do anything you want with root permission.

## Result
As the screenshot shows below, the password of root access is saved in passwd.sh(figure 1). And this file can be identified in the same package(figure 2)

figure 1:
![image](https://github.com/user-attachments/assets/d29c749f-13f1-4aca-92e3-c13654b8d4e3)

figure 2:
![image](https://github.com/user-attachments/assets/08cd9f4d-f95f-41cf-a8a3-64011fd87626)



