
# CVE-2025-45346 – Bacula-Web Time-Based SQL Injection (PostgreSQL Version Extraction)

## 📝 Overview

**Vulnerability Title**: Time-Based Blind SQL Injection in Bacula-Web  
**Product**: Bacula-Web  
**Versions Affected**: Confirmed in versions supporting PostgreSQL backend  
**CVE ID**: CVE-2025-45346  
**Severity**: High  
**Attack Vector**: Remote  
**Impact**: Arbitrary SQL Execution, Information Disclosure

---

## 🧨 Description

This proof-of-concept (PoC) demonstrates a **time-based blind SQL injection** vulnerability in the `jobfiles` endpoint of **Bacula-Web**.  
A remote attacker can leverage this flaw to extract information from the underlying PostgreSQL database — including the database version — by triggering deliberate delays using the `pg_sleep()` function.

---

## 🚀 Features

- Confirms presence of SQL injection via time delay test
- Automatically extracts PostgreSQL version character-by-character
- Utilizes URL-encoded payloads for precision
- Prints live progress during version extraction

---

## 📌 Usage

### ⚙️ Requirements

- Python 3.x
- `requests` library (`pip install requests`)

### 🔧 Configuration

Edit the script and set:

```python
base_url = "http://baculaweb.domain/jobfiles/29/1/"
cookies = {"Bacula-Web": "REPLACEME"}
```

Replace:
- `base_url` with your Bacula-Web target URL
- `REPLACEME` with your valid Bacula-Web session cookie

### 🏃 Run the Script

```bash
python3 extract_pgsql_version.py
```

---

## 🧾 Exploit Workflow

1. Sends a benign SQL payload with `pg_sleep(2)` to verify injection.
2. If the server response takes ~2s, the script proceeds to extract the version.
3. It loops through positions in the PostgreSQL version string using `SUBSTRING()` and compares characters one-by-one.
4. Delay-based detection identifies the correct character.

---

## 🔐 Impact

- Exposes sensitive database information to remote attackers
- May be leveraged to chain into further SQL-based exploitation
- Undermines trust in the web interface for backup job visibility

---

## 🛡️ Mitigation

- Apply input validation on the `jobfiles` route
- Use parameterized queries in backend logic
- Upgrade Bacula-Web to the latest patched version (once available)

---

## 👨‍💻 Discoverer

Security Researcher – **Kevin Suckiel**  -- 0xsu3ks
PoC for CVE-2025-45346 disclosed via responsible disclosure.

---

## ⚠️ Legal Notice

This tool is provided for **authorized testing and research purposes only**.  
The author is not responsible for any unauthorized use or misuse of this PoC.
