# CVE-2025-4517 PoC – Python tarfile Arbitrary File Write via Path Traversal

**CVE-2025-4517** (CVSS 9.4 – Critical)  
A vulnerability in Python's `tarfile` module that allows arbitrary file writes outside the extraction directory when using `TarFile.extractall()` or `TarFile.extract()` with `filter="data"` or `filter="tar"`.

**Affected versions**:
- Python 3.12+ when explicitly using `filter="data"` or `filter="tar"`
- Python 3.14+ (when relying on the new default `filter="data"`)

**Fixed in**:
- Python 3.12.11, 3.13.4, 3.11.13+ (patches released mid-2025)

This PoC creates a malicious `.tar` archive that attempts to **overwrite `/etc/sudoers`** (adding a passwordless sudo entry for user `wacky`) when extracted on a vulnerable system.

**DISCLAIMER**  
This code is provided **strictly for educational purposes**, authorized security research, CTF challenges and red-team exercises.  
**Do NOT use this against any system without explicit written permission.**  
Misuse may violate computer fraud and abuse laws in your jurisdiction.

## How It Works (High-Level)

1. Creates deep nested directories with very long names + same-name symlinks (causing path confusion/loops).
2. Builds a long symlink chain that escapes many directory levels upward using `../`.
3. Points an "escape" symlink → traversal → `/etc`.
4. Uses a **hard link** (`LNKTYPE`) to alias a file inside the tar to the escaped path (`/etc/sudoers`).
5. Writes payload content to the hard-linked name → overwrites the target file on extraction.

## Requirements

- Python 3.x (any modern version) to **generate** the exploit
- Vulnerable extractor on target:
  - GNU tar ≤ 1.34
  - bsdtar/libarchive in compatibility mode
  - Python `tarfile` with vulnerable filter settings
  - Backup/restore scripts without path restrictions

## Generate the Malicious Tar

```bash
# 1. Save the PoC as generate_exploit.py
# 2. Run:
python3 generate_exploit.py
