import hashlib
import sys

salt = "" #Insert the obtained salt
final_hash = "" #Insert the obtained hash

def md5_hash(value):
	return hashlib.md5(value.encode()).hexdigest()

def check_passwords_from_file(filename, salt, final_hash):
	try:
		with open(filename, 'r', encoding='latin-1') as file:
			passwords = file.readlines()

			for index, password_str in enumerate(passwords):
				password_str = password_str.strip()

				hashed_pass = md5_hash(password_str + salt)

				for num in range(1, 15):
					truncated_salt = salt[:(20 - num)]
					hashed_pass = md5_hash(hashed_pass + truncated_salt)

				if hashed_pass == final_hash:
					return password_str

	except Exception as e:
		print(f"Error while reading file: {e}")

	return None

def main():
	if len(sys.argv) != 2:
		print("Usage: python3 brute.py passwords.txt")
		sys.exit(1)

	filename = sys.argv[1]
	found_password = check_passwords_from_file(filename, salt, final_hash)

	if found_password:
		print(f"\033[92mFound the password: {found_password}\033[0m")
	else:
		print("No match found after checking all passwords in the file.")

if __name__ == "__main__":
	main()
