# CVE-2025-44203 HotelDruid 3.0.0 / 3.0.7 Sensitive Information Disclosure, DoS

A Sensitive Information Disclosure vulnerability due to verbose SQL error messages, and a Denial of Service vulnerability exist in HotelDruid versions 3.0.0 and 3.0.7, on the endpoint 'creadb.php', before the 'create database' button is pressed, at the same endpoint.

By sending multiple POST requests, an attacker may obtain sensitive information such as username, password hash, and salt.

If the password set during the debian package configuration is weak to bruteforce/dictionary attacks, an attacker might recover the plaintext password.

If the exploit works successfully, the administrator won't be able to login with the credentials they previously set during the HotelDruid .deb package configuration.

Demos showcasing the CVE are available at:

HotelDruid version 3.0.0:
https://www.youtube.com/watch?v=LqJ-SXZtvBQ

HotelDruid version 3.0.7:
https://www.youtube.com/watch?v=Y5ZyAaNvRlo

Other info:

For a remote attacker to exploit these flaws, during the HotelDruid debian package configuration, the option "Restrict HotelDruid access to localhost?" should be set to: No

The exploit might not always work. If it doesn't work, the vulnerability can't be exploited again (a new HotelDruid installation is required).

The exploit was tested on HotelDruid versions 3.0.0 and 3.0.7. Other versions might be affected as well.

To run the exploit against a remote target, from the attacker machine, run:

```python3 exploit.py 192.168.1.1```

where '192.168.1.1' is the IP address of the machine on which HotelDruid was installed.

If the exploitation worked successfully, you can use brute.py and a wordlist file, to try and obtain the plaintext password.

Edit brute.py, and:

Replace the contents of the variable 'salt', with the obtained salt.

Replace the contents of the variable 'final_hash', with the obtained password hash.

Save brute.py, and then run:

```python3 brute.py rockyou.txt```

where 'rockyou.txt' is a file that contains plaintext passwords.

After obtaining the username and plaintext password, you can try to login on the HotelDruid instance, but you won't be able to do so (same goes for the administrator), due to the username or password not being correct.

Links:

https://nvd.nist.gov/vuln/detail/CVE-2025-44203

https://www.cve.org/CVERecord?id=CVE-2025-44203

https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-44203

