
# CVE-2025-44108  - Stored cross site scripting(XSS) vulnerabilities in the FlatPress CMS 1.3.1

## Description 
A stored Cross-Site Scripting (XSS) vulnerability exists in the administration panel of Flatpress CMS 1.3.1. An attacker with admin privileges can inject a malicious JavaScript payload into the system, which is then stored persistently.

When a regular user visits the compromised page (e.g., a blog post), the injected payload executes automatically in the victim's browser.

## Affected product
- [Flatpress](https://www.flatpress.org/)
- Version : <=1.3.1
- Component : Gallery captions  

## ⚠️ Impact
- Steal session cookies. 
- Phishing Attacks
- Redirect users to malicious sites. 

# Step to Reproduce:

1.Download the FlatPress CMS from a trustworthy source. (https://github.com/flatpressblog/flatpress)

2.Launch a local PHP server using the command: php -S 127.0.0.1:80

3.Open the following URL in your browser: http://127.0.0.1/admin.php?p=uploader&action=gallerycaptions

4.In Administration area -> uploader->Gallery Captions, in that area you can edit the caption for the images, inject the payload and save , when ever site vister or admin vist the blog post the stored xss will get excute.



![Imge](https://github.com/harish0x/harish0x.github.io/blob/master/assets/img/cve44108/1.png)   
  
   

![Imge](https://github.com/harish0x/harish0x.github.io/blob/master/assets/img/cve44108/2.png)   

  

![Imge](https://github.com/harish0x/harish0x.github.io/blob/master/assets/img/cve44108/3.png) 
  


![Imge](https://github.com/harish0x/harish0x.github.io/blob/master/assets/img/cve44108/4.png)

   
   


```html
1. <iframe src="data:text/html;base64,PHNjcmlwdD5hbGVydCgnb2theSB4c3MnKTwvc2NyaXB0Pg=="></iframe>


2. <IFRAME SRC=# onmouseover="alert(document.cookie)"></IFRAME>

```


# Code area
[Flatpress github](https://github.com/flatpressblog/flatpress/commit/02a69013214a7d4c32b6b85aad7006b52acca329)

# Reference:
https://portswigger.net/web-security/cross-site-scripting

# Fixed Version
FlatPress 1.4 "Notturno" [link](https://www.flatpress.org/2025/01/20/flatpress-14-notturno-release-candidate-1-published/)

##  CVE Assignment
- **CVE ID:** CVE-2025-44108
