# CVE-2025-4403 Exploit 

### Details

- **Published**: May 8, 2025
- **Updated**: May 9, 2025
- **Severity**: High (CVSS Score: 9.8)
- **CWE**: CWE-434 - Unrestricted Upload of File with Dangerous Type
- **Affected Versions**: All versions from n/a through 1.1.6

### CVSS Vector

- **CVSS Version**: 9.8
- **Vector String**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H

## Description

The Drag and Drop Multiple File Upload for WooCommerce plugin for WordPress is vulnerable to arbitrary file uploads in all versions up to, and including, 1.1.6 due to accepting a user‐supplied supported_type string and the uploaded filename without enforcing real extension or MIME checks within the upload() function. This makes it possible for unauthenticated attackers to upload arbitrary files on the affected site's server which may make remote code execution possible.

### Usage

```sh
usage: python3 CVE-2025-4403.py
```

## Script Details

### Requirements

- Python 3.x
- `requests` library

### Installation

1. Clone the repository:
    ```sh
    git clone https://github.com/Yucaerin/CVE-2025-4403.git
    cd CVE-2025-4403
    ```

2. Install the required Python packages:
    ```sh
    pip install requests
    ```

## Disclaimer

This script is intended for educational purposes only. Use it responsibly and only on systems for which you have explicit permission. Unauthorized use of this script is illegal and unethical.
