# CVE-2025-43921: Unauthenticated Mailing List Creation in GNU Mailman 2.1.39 (cPanel/WHM Bundle)

**Discovered by:** Firudin Davudzada & Musazada Aydan\
**Disclosure Date:** April 2025\
**CVE ID:** CVE-2025-43921\
**Severity:** 5.3 Medium (CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N)\
**Attack Type:** Remote\
**Affected Software:** GNU Mailman 2.1.39 (bundled with cPanel/WHM)

## Overview

GNU Mailman 2.1.39, as bundled with cPanel and WHM, is vulnerable to an authentication bypass flaw that allows unauthenticated attackers to create mailing lists via the `/mailman/create` endpoint. The issue stems from missing access controls in the `create` CGI script, enabling attackers to abuse the mailing system for spam, phishing, or resource exhaustion.

This vulnerability aligns with historical access control issues in Mailman, such as improper list management permissions in Postorius. It can be chained with CVE-2025-43920 to escalate impact, creating a platform for broader attacks.

## Vulnerability Details

- **Vulnerability Type:** Authentication Bypass / Access Control Misconfiguration
- **Vendor:** GNU Mailman (https://www.gnu.org/software/mailman/)
- **Affected Versions:** Mailman 2.1.39; likely affects older 2.1.x versions (pending regression testing)
- **Affected Components:**
  - `create` CGI script (handles list creation requests)
  - `Mailman/Handlers/` (list management logic)
- **Root Cause:** Absence of authentication checks for POST requests to `/mailman/create`, allowing arbitrary list creation.
- **Status:** No official fix available. Mailman 2.1.x is end-of-life (EOL); migration to Mailman 3.x is strongly recommended.

## Proof of Concept

The following command creates a mailing list named `hacked`:

```bash
curl http://target/mailman/create -d "listname=hacked&owner=you@you.com&password=1234&confirm=1234"
```

**Expected Outcome:** A new mailing list is created, controllable by the attacker-specified owner email.

## Attack Vectors

- **Primary Vector:** Unauthenticated HTTP POST requests to `/mailman/create` with crafted parameters to create mailing lists.
- **Exploitation Scenarios:**
  - Create unauthorized lists for spam or phishing campaigns.
  - Overload server resources by creating numerous lists.
  - Combine with CVE-2025-43920 to execute commands via crafted list configurations.
- **Ease of Exploitation:** High, as the endpoint is publicly accessible by default.

## Security Impact

- **Information Disclosure:** Moderate (post-creation access to list metadata or subscriber data).
- **Code Execution:** Possible (if chained with CVE-2025-43920).
- **Privilege Escalation:** Moderate (unauthorized control over mailing lists).
- **Denial of Service:** Moderate (resource exhaustion from excessive list creation).

## Mitigations

### Immediate Actions

- **Block Endpoint Access:** Configure the web server to restrict access to `/mailman/create`:

  ```nginx
  location /mailman/create {
      deny all;
      return 403;
  }
  ```

  Or for Apache:

  ```apache
  <Location "/mailman/create">
      Deny from all
  </Location>
  ```

- **Monitor Logs:** Check for unauthorized list creation attempts:

  ```bash
  tail -f /var/log/mailman/* | grep "newlist"
  ```

### Long-Term Solutions

- **Upgrade to Mailman 3.x:** Migrate to Mailman 3.x, which enforces authentication for list creation.
- **Disable List Creation:** If not required, disable web-based list creation in Mailman settings.
- **Implement Rate-Limiting:** Apply rate-limiting on `/mailman/create` to prevent abuse.
- **Historical Context:** Access control issues in Mailman, such as those in Postorius, were mitigated by enforcing stricter permissions. Upgrading to Mailman 3.x is critical for EOL systems.

## Timeline

- **Q1 2025:** Vulnerability discovered during authorized penetration testing assessment.
- **Q1 2025:** Reported to GNU Mailman and cPanel maintainers.
- **April 2025:** CVE assigned by MITRE.
- **April 2025:** Public disclosure via this repository.

## References

- [Mailman 2.1 Source Code](https://code.launchpad.net/~mailman-coders/mailman/2.1)
- [CVE-2025-43921 Record](https://www.cve.org/CVERecord?id=CVE-2025-43921)
- [National Institute of Standards and Technology (NIST) - CVE-2025-43921](https://nvd.nist.gov/vuln/detail/CVE-2025-43921)
- [Mailman Security Recommendations](https://wiki.list.org/DOC/Mailman%202.1%20List%20Administrators%20Manual)
- [Tenable - CVE-2025-43921](https://www.tenable.com/cve/CVE-2025-43921)
- [OpenCVE - CVE-2025-43921](https://app.opencve.io/cve/CVE-2025-43921)
- [SecAlerts  - CVE-2025-43921](https://secalerts.co/vulnerability/CVE-2025-43921)
- [AliYun  - CVE-2025-43921](https://avd.aliyun.com/detail?id=AVD-2025-43921&timestamp__1384=eqGxuDBDnii%3DIx7qGNRCDUrcKruo2gbD)

## Acknowledgments

Firudin Davudzada and Musazada Aydan responsibly disclosed this vulnerability during a sanctioned penetration testing engagement. Thanks to the MITRE CVE team for coordination.

## Contact

**Email:** security@datricon.com\
