# CVE-2025-43919: Directory Traversal in GNU Mailman 2.1.39 (cPanel/WHM Bundle)

**Discovered by:** Firudin Davudzada & Musazada Aydan  
**Disclosure Date:** April 2025  
**CVE ID:** [CVE-2025-43919](https://www.cve.org/CVERecord?id=CVE-2025-43919)  
**Severity:** 5.8 Medium (CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:N)  
**Attack Type:** Remote  
**Affected Software:** GNU Mailman 2.1.39 (bundled with cPanel/WHM)  

## Overview

GNU Mailman 2.1.39, as bundled with cPanel and WHM, contains a critical directory traversal vulnerability in the `/mailman/private/mailman` endpoint. Unauthenticated attackers can exploit this flaw to read arbitrary files on the server, such as `/etc/passwd` or Mailman configuration files, due to insufficient input validation in the `private.py` CGI script. This vulnerability poses significant risks for information disclosure and can facilitate further attacks when combined with other exploits.

## Vulnerability Details

- **Vulnerability Type:** Directory Traversal  
- **Vendor:** GNU Mailman ([GNU Mailman](https://www.gnu.org/software/mailman/))  
- **Affected Versions:** Mailman 2.1.39; likely affects older 2.1.x versions (pending regression testing)  
- **Affected Components:**
  - `private.py` CGI script (handles private archive authentication)
  - `archive.py` (archive processing logic)
  - `Mailman/Handlers/` (core mailing list logic)
  - Potential exposure of `.mbox` archive files
- **Root Cause:** The `username` parameter in POST requests to `/mailman/private/mailman` is not sanitized, allowing `../` sequences to traverse the filesystem.
- **Status:** No official fix available. Mailman 2.1.x is end-of-life (EOL); migration to Mailman 3.x is strongly recommended.

## Proof of Concept

The following command demonstrates unauthorized access to `/etc/passwd`:

```bash
curl -X POST -d "username=../../../../etc/passwd&password=x&submit=Let+me+in..." http://target/mailman/private/mailman
```

**Expected Output:** Contents of `/etc/passwd` or other targeted files, depending on server permissions.

## Attack Vectors

- **Primary Vector:** Unauthenticated HTTP POST requests to `/mailman/private/mailman` with crafted `username` parameters containing `../`.
- **Exploitation Scenarios:**
  - Retrieve sensitive system files (e.g., `/etc/passwd`, `/etc/shadow` if permissions allow).
  - Access Mailman configuration files or `.mbox` archives to extract user data or email content.
  - Use disclosed information to chain with other vulnerabilities for escalated attacks.
- **Ease of Exploitation:** High, as the endpoint is publicly accessible and requires no authentication.

## Security Impact

- **Information Disclosure:** High (exposure of sensitive file contents).
- **Code Execution:** Possible (if disclosed files enable further exploits).
- **Privilege Escalation:** Possible (if sensitive data provides access to privileged accounts).
- **Denial of Service:** Moderate (resource exhaustion from repeated file access attempts).

## Mitigations

### Immediate Actions

- **Restrict Endpoint Access:** Configure the web server to block unauthorized access to `/mailman/private`:

  ```apache
  <Location "/mailman/private">
      Require ip 127.0.0.1
      Deny from all
  </Location>
  ```

  Or for Nginx:

  ```nginx
  location /mailman/private {
      deny all;
      return 403;
  }
  ```

- **Monitor Logs:** Check for suspicious POST requests to `/mailman/private/mailman`:

  ```bash
  tail -f /var/log/httpd/access_log | grep "/mailman/private"
  ```

### Long-Term Solutions

- **Upgrade to Mailman 3.x:** Migrate to [Mailman 3.x](https://www.list.org/), which includes robust input validation and is actively maintained.
- **Disable Web Interface:** If not required, disable Mailman’s web interface to reduce the attack surface.
- **Harden Filesystem:** Ensure sensitive files and directories have strict permissions to prevent unauthorized access.

## Timeline

- **Q1 2025:** Discovered during authorized penetration testing assessment.
- **Q1 2025:** Reported to GNU Mailman and cPanel maintainers.
- **April 2025:** CVE assigned by MITRE.
- **April 2025:** Public disclosure via this repository.

## References

- [Mailman 2.1 Source Code](https://code.launchpad.net/~mailman-coders/mailman/2.1)
- [CVE-2025-43919 Record](https://www.cve.org/CVERecord?id=CVE-2025-43919)
- [National Institute of Standards and Technology (NIST) - CVE-2025-43919](https://nvd.nist.gov/vuln/detail/CVE-2025-43919)
- [Mailman Security Recommendations](https://wiki.list.org/DOC/Mailman%202.1%20List%20Administrators%20Manual)
- [Tenable - CVE-2025-43919](https://www.tenable.com/cve/CVE-2025-43919)
- [OpenCVE - CVE-2025-43919](https://app.opencve.io/cve/CVE-2025-43919)
- [SecAlerts  - CVE-2025-43919](https://secalerts.co/vulnerability/CVE-2025-43919)
- [AliYun  - CVE-2025-43919](https://avd.aliyun.com/detail?id=AVD-2025-43919&timestamp__1384=eqGxuDBDnii%3DGQq0%3DD%2FYnEf%3DD9QGDgYo1%3DYD)


## Acknowledgments

Firudin Davudzada and Musazada Aydan responsibly disclosed this vulnerability during a sanctioned penetration testing engagement. Thanks to the MITRE CVE team for coordination.

## Contact
**Email:** security@datricon.com  
