# 🔐 CVE-2025-4322 – Motors <= 5.6.67 - Unauthenticated Privilege Escalation via Password Update/Account Takeover

## 📌 Themes Information
- **Plugin**: Motors <= 5.6.67 - Unauthenticated Privilege Escalation via Password Update/Account Takeover
- **Vulnerable Version**: <= 5.6.67
- **CVE**: CVE-2025-4322
- **Severity**: 9.8 (Critical)
- **CWE ID**: CWE-620
- **CWE Name**: Unverified Password Change
- **Patched**: ✅ Yes
- **Patch Priority**: 🔴 Critical
- **Date Published**: May 19, 2025
- **Researcher**: https://www.wordfence.com/threat-intel/vulnerabilities/researchers/friderika-baranyai

---

## ⚠️ Summary of the Vulnerability
The Motors WordPress theme (up to and including version 5.6.67) contains a critical authentication flaw in its password reset functionality.

It provides a front-end password update mechanism via endpoints, but fails to properly validate user identity or authorization before processing password changes.

As a result, unauthenticated attackers can send crafted HTTP requests that supply a user_id, an arbitrary hash_check, and a new password (stm_new_password) to reset any user’s password — including administrators.

If exploited, this allows attackers to:

Gain administrative access,

Take over the entire site,

Deploy persistent backdoors or malicious plugins.

This flaw is especially dangerous because it requires no login, and often leaves no obvious trace unless logs are monitored.

## 🧪 Proof of Concept (PoC)

### 📥 **Request** (e.g., via curl):
```http
curl "https://local.ization/loginregister/?user_id=2&hash_check=%C0" --data "stm_new_password=randomizer" -XPOST -v -H 'User-Agent: Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36'
```
---

## 🛠️ Where’s the flaw?

- The Motors theme exposes a front-end password reset handler via endpoints like /login, /register, /loginregister, etc
- This handler accepts user_id, hash_check, and stm_new_password via unauthenticated HTTP POST requests
- The theme fails to verify the identity or authenticity of the requester
- As long as an attacker supplies a valid or bypassable hash_check, the system processes password changes blindly
- There is no authentication, nonce validation, or ownership check before updating user credentials

---

## 🔐 Recommendation

- Disable or restrict access to the /loginregister/ or similar front-end endpoints if not in use
- Implement strict identity validation before processing password reset requests (e.g., logged-in user check, secure token validation)
- Avoid relying on client-supplied user_id or hash_check without server-side verification
- Apply updates to the latest version of the Motors theme, or use virtual patching (e.g., via WAF) to block unauthorized POST requests
- Regularly audit public-facing endpoints for unexpected or undocumented behavior

---

## ⚠️ Disclaimer

This report is for **educational and authorized security testing purposes only**.  
Exploitation of this vulnerability without permission may violate legal and ethical boundaries.

---
