import requests
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

from bs4 import BeautifulSoup
from urllib.parse import urljoin, urlparse
from concurrent.futures import ThreadPoolExecutor
import threading

lock = threading.Lock()

with open("list.txt") as f:
    domains = [line.strip().replace("http://", "").replace("https://", "") for line in f if line.strip()]

login_paths = [
    "/login",
    "/loginregister",
    "/login-register",
    "/my-account",
    "/account",
    "/signin",
    "/sign-in",
    "/register",
    "/auth",
    "/user/login",
    "/user/signin",
    "/forgot-password",
    "/reset-password"
]

def check_login_form(full_url):
    try:
        res = requests.get(full_url, timeout=10, verify=False)
        if res.status_code == 200 and "stm-login-form" in res.text:
            return True
    except:
        pass
    return False

def process_domain(domain):
    checked = set()
    base_url = f"https://{domain}"
    try:
        r = requests.get(base_url, timeout=10, verify=False)
        if r.status_code != 200:
            return
        soup = BeautifulSoup(r.text, "html.parser")

        if "stm-login-form" in r.text:
            print(f"[✅] {domain} → found at homepage")
            with lock:
                with open("result.txt", "a") as f:
                    f.write(domain + "\n")
            return

        hrefs = set()
        for a in soup.find_all("a", href=True):
            href = a["href"]
            if any(kw in href.lower() for kw in ["login", "register", "account", "signin", "forgot", "reset"]):
                full_href = urljoin(base_url, href)
                hrefs.add(full_href)

        for path in login_paths:
            hrefs.add(urljoin(base_url, path))

        for link in hrefs:
            normalized = urlparse(link)._replace(query="", fragment="").geturl()
            if normalized in checked:
                continue
            checked.add(normalized)
            if check_login_form(normalized):
                print(f"[✅] {domain} → found at {normalized}")
                with lock:
                    with open("result.txt", "a") as f:
                        f.write(domain + "\n")
                break
    except Exception as e:
        print(f"[⚠️] {domain} → error: {e}")

print(f"[🚀] ready to check {len(domains)} domain...")

with ThreadPoolExecutor(max_workers=20) as executor:
    executor.map(process_domain, domains)

print(f"[✔️] Done. all valid result at result.txt")
